/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.renderer.printer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.printer.XMLWikiPrinter;
import org.xwiki.xml.html.HTMLElementSanitizer;

public class XHTMLWikiPrinter
extends XMLWikiPrinter {
    public static final String TRANSLATED_ATTRIBUTE_PREFIX = "data-xwiki-translated-attribute-";
    private static final Pattern DATA_REPLACEMENT_PATTERN = Pattern.compile("[^A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\x{10000}-\\x{EFFFF}\\-.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040]");
    private static final List<String> FORBIDDEN_RAW_SUFFIX_PREFIXES = XHTMLWikiPrinter.computeForbiddenRawSuffixPrefixes();
    private static final String[] FORBIDDEN_RAW_STRINGS = new String[]{"{{html", "{{/html"};
    private static final String[] FORBIDDEN_RAW_REPLACEMENTS = new String[]{"&#123;&#123;html", "&#123;&#123;/html"};
    protected final HTMLElementSanitizer htmlElementSanitizer;
    private int spaceCount;
    private boolean isInCData;
    private boolean isInPreserveElement;
    private boolean elementEnded;
    private boolean hasTextBeenPrinted;
    private boolean isStandalone;

    public XHTMLWikiPrinter(WikiPrinter printer) {
        this(printer, null);
    }

    public XHTMLWikiPrinter(WikiPrinter printer, HTMLElementSanitizer htmlElementSanitizer) {
        super(printer);
        this.htmlElementSanitizer = htmlElementSanitizer;
    }

    public void setStandalone() {
        this.isStandalone = true;
    }

    @Override
    public void printXML(String str) {
        this.handleSpaceWhenInText();
        super.printXML(str);
        this.hasTextBeenPrinted = true;
        this.isStandalone = false;
    }

    @Override
    public void printXMLElement(String name) {
        if (this.htmlElementSanitizer == null || this.htmlElementSanitizer.isElementAllowed(name)) {
            this.handleSpaceWhenStartElement();
            super.printXMLElement(name);
        }
    }

    @Override
    public void printXMLElement(String name, String[][] attributes) {
        if (this.htmlElementSanitizer == null || this.htmlElementSanitizer.isElementAllowed(name)) {
            this.handleSpaceWhenStartElement();
            super.printXMLElement(name, this.cleanAttributes(name, attributes));
        }
    }

    @Override
    public void printXMLElement(String name, Map<String, String> attributes) {
        if (this.htmlElementSanitizer == null || this.htmlElementSanitizer.isElementAllowed(name)) {
            this.handleSpaceWhenStartElement();
            super.printXMLElement(name, this.cleanAttributes(name, attributes));
        }
    }

    @Override
    public void printXMLStartElement(String name) {
        if (this.htmlElementSanitizer == null || this.htmlElementSanitizer.isElementAllowed(name)) {
            this.handleSpaceWhenStartElement();
            super.printXMLStartElement(name);
        }
    }

    @Override
    public void printXMLStartElement(String name, String[][] attributes) {
        if (this.htmlElementSanitizer == null || this.htmlElementSanitizer.isElementAllowed(name)) {
            this.handleSpaceWhenStartElement();
            super.printXMLStartElement(name, this.cleanAttributes(name, attributes));
        }
    }

    @Override
    public void printXMLStartElement(String name, Map<String, String> attributes) {
        if (this.htmlElementSanitizer == null || this.htmlElementSanitizer.isElementAllowed(name)) {
            this.handleSpaceWhenStartElement();
            super.printXMLStartElement(name, this.cleanAttributes(name, attributes));
        }
    }

    @Override
    public void printXMLStartElement(String name, Attributes attributes) {
        if (this.htmlElementSanitizer == null || this.htmlElementSanitizer.isElementAllowed(name)) {
            this.handleSpaceWhenStartElement();
            super.printXMLStartElement(name, this.cleanAttributes(name, attributes));
        }
    }

    @Override
    public void printXMLEndElement(String name) {
        if (this.htmlElementSanitizer == null || this.htmlElementSanitizer.isElementAllowed(name)) {
            this.handleSpaceWhenEndlement();
            super.printXMLEndElement(name);
            this.elementEnded = true;
        }
    }

    @Override
    public void printXMLComment(String content) {
        this.printXMLComment(content, false);
    }

    @Override
    public void printXMLComment(String content, boolean escape) {
        this.handleSpaceWhenStartElement();
        super.printXMLComment(content, escape);
        this.elementEnded = true;
    }

    @Override
    public void printXMLStartCData() {
        this.handleSpaceWhenStartElement();
        super.printXMLStartCData();
    }

    @Override
    public void printXMLEndCData() {
        this.handleSpaceWhenEndlement();
        super.printXMLEndCData();
    }

    public void printSpace() {
        ++this.spaceCount;
    }

    @Override
    public void printRaw(String raw) {
        this.handleSpaceWhenStartElement();
        Object escapedRaw = StringUtils.replaceEach((String)raw, (String[])FORBIDDEN_RAW_STRINGS, (String[])FORBIDDEN_RAW_REPLACEMENTS);
        for (String prefix : FORBIDDEN_RAW_SUFFIX_PREFIXES) {
            if (!((String)escapedRaw).endsWith(prefix)) continue;
            escapedRaw = ((String)escapedRaw).substring(0, ((String)escapedRaw).length() - prefix.length()) + "&#123;" + prefix.substring(1);
            break;
        }
        super.printRaw((String)escapedRaw);
        this.elementEnded = true;
    }

    private static List<String> computeForbiddenRawSuffixPrefixes() {
        ArrayList<String> forbidden = new ArrayList<String>(12);
        forbidden.add("{");
        for (String suffix : List.of("{/html", "{html")) {
            for (int i = 2; i <= suffix.length(); ++i) {
                forbidden.add(suffix.substring(0, i));
            }
        }
        return forbidden;
    }

    private void handleSpaceWhenInText() {
        if (this.elementEnded || this.hasTextBeenPrinted) {
            this.handleSpaceWhenStartElement();
        } else {
            this.handleSpaceWhenEndlement();
        }
    }

    private Map<String, String> cleanAttributes(String elementName, Map<String, String> attributes) {
        Map<String, String> cleanAttributes;
        if (this.htmlElementSanitizer == null || attributes == null) {
            cleanAttributes = attributes;
        } else {
            cleanAttributes = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> e : attributes.entrySet()) {
                if (this.htmlElementSanitizer.isAttributeAllowed(elementName, e.getKey(), e.getValue())) {
                    cleanAttributes.put(e.getKey(), e.getValue());
                    continue;
                }
                String translatedName = TRANSLATED_ATTRIBUTE_PREFIX + XHTMLWikiPrinter.removeInvalidDataAttributeCharacters(e.getKey());
                if (!this.htmlElementSanitizer.isAttributeAllowed(elementName, translatedName, e.getValue())) continue;
                cleanAttributes.put(translatedName, e.getValue());
            }
        }
        return cleanAttributes;
    }

    private String[][] cleanAttributes(String elementName, String[][] attributes) {
        String[][] allowedAttributes = this.htmlElementSanitizer == null || attributes == null ? attributes : (String[][])Arrays.stream(attributes).map(entry -> {
            if (this.htmlElementSanitizer.isAttributeAllowed(elementName, entry[0], entry[1])) {
                return entry;
            }
            String translatedName = TRANSLATED_ATTRIBUTE_PREFIX + XHTMLWikiPrinter.removeInvalidDataAttributeCharacters(entry[0]);
            if (this.htmlElementSanitizer.isAttributeAllowed(elementName, translatedName, entry[1])) {
                return new String[]{translatedName, entry[1]};
            }
            return null;
        }).filter(Objects::nonNull).toArray(x$0 -> new String[x$0][]);
        return allowedAttributes;
    }

    private Attributes cleanAttributes(String elementName, Attributes attributes) {
        Attributes allowedAttribute;
        if (this.htmlElementSanitizer == null || attributes == null) {
            allowedAttribute = attributes;
        } else {
            allowedAttribute = new AttributesImpl();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (this.htmlElementSanitizer.isAttributeAllowed(elementName, attributes.getQName(i), attributes.getValue(i))) {
                    ((AttributesImpl)allowedAttribute).addAttribute(null, null, attributes.getQName(i), null, attributes.getValue(i));
                    continue;
                }
                String translatedName = TRANSLATED_ATTRIBUTE_PREFIX + XHTMLWikiPrinter.removeInvalidDataAttributeCharacters(attributes.getQName(i));
                if (!this.htmlElementSanitizer.isAttributeAllowed(elementName, translatedName, attributes.getValue(i))) continue;
                ((AttributesImpl)allowedAttribute).addAttribute(null, null, translatedName, null, attributes.getValue(i));
            }
        }
        return allowedAttribute;
    }

    public static String removeInvalidDataAttributeCharacters(String name) {
        return DATA_REPLACEMENT_PATTERN.matcher(name).replaceAll("");
    }

    private void handleSpaceWhenStartElement() {
        if (this.spaceCount > 0) {
            if (!this.isInCData && !this.isInPreserveElement) {
                if (this.isStandalone && !this.hasTextBeenPrinted) {
                    this.printEntity("&nbsp;");
                } else {
                    super.printXML(" ");
                }
                for (int i = 0; i < this.spaceCount - 1; ++i) {
                    this.printEntity("&nbsp;");
                }
            } else {
                super.printXML(StringUtils.repeat((char)' ', (int)this.spaceCount));
            }
            this.isStandalone = false;
        }
        this.spaceCount = 0;
        this.elementEnded = false;
        this.hasTextBeenPrinted = false;
    }

    private void handleSpaceWhenEndlement() {
        if (!this.isInCData && !this.isInPreserveElement) {
            for (int i = 0; i < this.spaceCount; ++i) {
                this.printEntity("&nbsp;");
            }
        } else {
            super.printXML(StringUtils.repeat((char)' ', (int)this.spaceCount));
        }
        this.spaceCount = 0;
        this.elementEnded = false;
        this.hasTextBeenPrinted = false;
    }
}

