/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.impl.WikiScannerContext;
import org.xwiki.rendering.wikimodel.xhtml.handler.BlockTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.BoldTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.BreakTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.CommentHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.DefinitionDescriptionTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.DefinitionTermTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.DivisionTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.HeaderTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.HorizontalLineTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ImgTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ItalicTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ListItemTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ListTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ParagraphTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.PreserveTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.QuoteTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.ReferenceTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.SpanTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.StrikedOutTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.SubScriptTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.SuperScriptTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TableDataTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TableRowTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TableTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TeletypeTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.UnderlineTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagStack;

public class XhtmlHandler
extends DefaultHandler
implements LexicalHandler {
    private TagStack fStack;

    public XhtmlHandler(WikiScannerContext context, Map<String, TagHandler> extraHandlers) {
        this(context, extraHandlers, new CommentHandler());
    }

    public XhtmlHandler(WikiScannerContext context, Map<String, TagHandler> extraHandlers, CommentHandler commentHandler) {
        HashMap<String, TagHandler> handlers = new HashMap<String, TagHandler>();
        handlers.put("p", new ParagraphTagHandler());
        handlers.put("table", new TableTagHandler());
        handlers.put("tr", new TableRowTagHandler());
        TagHandler handler = new TableDataTagHandler();
        handlers.put("td", handler);
        handlers.put("th", handler);
        handler = new ListTagHandler();
        handlers.put("ul", handler);
        handlers.put("ol", handler);
        handlers.put("dl", handler);
        handler = new ListItemTagHandler();
        handlers.put("li", handler);
        handlers.put("dt", new DefinitionTermTagHandler());
        handlers.put("dd", new DefinitionDescriptionTagHandler());
        handler = new HeaderTagHandler();
        handlers.put("h1", handler);
        handlers.put("h2", handler);
        handlers.put("h3", handler);
        handlers.put("h4", handler);
        handlers.put("h5", handler);
        handlers.put("h6", handler);
        handlers.put("hr", new HorizontalLineTagHandler());
        handlers.put("pre", new PreserveTagHandler());
        handlers.put("a", new ReferenceTagHandler());
        handlers.put("img", new ImgTagHandler());
        handler = new BoldTagHandler();
        handlers.put("strong", handler);
        handlers.put("b", handler);
        handler = new UnderlineTagHandler();
        handlers.put("ins", handler);
        handlers.put("u", handler);
        handler = new StrikedOutTagHandler();
        handlers.put("del", handler);
        handlers.put("strike", handler);
        handlers.put("s", handler);
        handler = new ItalicTagHandler();
        handlers.put("em", handler);
        handlers.put("i", handler);
        handlers.put("sup", new SuperScriptTagHandler());
        handlers.put("sub", new SubScriptTagHandler());
        handlers.put("tt", new TeletypeTagHandler());
        handlers.put("br", new BreakTagHandler());
        handlers.put("div", new DivisionTagHandler());
        handler = new QuoteTagHandler();
        handlers.put("blockquote", handler);
        handlers.put("quote", handler);
        handlers.put("span", new SpanTagHandler());
        handler = extraHandlers.get("div");
        handler = handler != null ? new BlockTagHandler(((BlockTagHandler)handler).getDocumentClass()) : new BlockTagHandler();
        handlers.put("aside", handler);
        handlers.put("section", handler);
        handlers.put("article", handler);
        handlers.put("main", handler);
        handlers.put("nav", handler);
        handlers.put("details", handler);
        handlers.put("summary", handler);
        handlers.put("figure", handler);
        handlers.put("figcaption", handler);
        handlers.put("header", handler);
        handlers.put("footer", handler);
        handlers.putAll(extraHandlers);
        this.fStack = new TagStack(context, handlers, commentHandler);
    }

    @Override
    public void characters(char[] array, int start, int length) throws SAXException {
        this.fStack.onCharacters(new String(array, start, length));
    }

    @Override
    public void endDocument() throws SAXException {
        TagHandler.sendEmptyLines(this.fStack);
        this.fStack.endElement();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.fStack.endElement();
    }

    @Override
    public void startDocument() throws SAXException {
        this.fStack.beginElement(null, null);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.fStack.beginElement(this.getLocalName(localName, qName, false), this.getParameters(attributes));
    }

    @Override
    public void comment(char[] array, int start, int length) throws SAXException {
        this.fStack.onComment(array, start, length);
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }

    private String getLocalName(String localName, String name, boolean upperCase) {
        String result = localName != null && !"".equals(localName) ? localName : name;
        return upperCase ? result.toUpperCase() : result;
    }

    private WikiParameters getParameters(Attributes attributes) {
        HashSet<String> keys = new HashSet<String>();
        ArrayList<WikiParameter> params = new ArrayList<WikiParameter>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String key = this.getLocalName(attributes.getQName(i), attributes.getLocalName(i), false);
            keys.add(key);
            String value = attributes.getValue(i);
            WikiParameter param2 = new WikiParameter(key, value);
            if (attributes instanceof Attributes2) {
                Attributes2 attributes2 = (Attributes2)attributes;
                if (!attributes2.isSpecified(i)) continue;
                params.add(param2);
                continue;
            }
            params.add(param2);
        }
        List<WikiParameter> translatedParameters = params.stream().filter(param -> {
            boolean keep;
            boolean bl = keep = !param.getKey().startsWith("data-xwiki-translated-attribute-");
            if (!keep) {
                String translatedKey = param.getKey().substring("data-xwiki-translated-attribute-".length());
                keep = !keys.contains(translatedKey);
            }
            return keep;
        }).map(param -> {
            if (param.getKey().startsWith("data-xwiki-translated-attribute-")) {
                String translatedKey = param.getKey().substring("data-xwiki-translated-attribute-".length());
                return new WikiParameter(translatedKey, param.getValue());
            }
            return param;
        }).collect(Collectors.toList());
        return new WikiParameters(translatedParameters);
    }
}

