/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.wikimodel.WikiPageUtil;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.impl.WikiScannerContext;
import org.xwiki.rendering.wikimodel.xhtml.XhtmlCharacter;
import org.xwiki.rendering.wikimodel.xhtml.XhtmlCharacterType;
import org.xwiki.rendering.wikimodel.xhtml.handler.AbstractFormatTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.CommentHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.IgnoreElementRule;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;

public class TagStack {
    private static final String QUOTE_DEPTH = "quoteDepth";
    private static final String INSIDE_BLOCK_ELEMENT = "insideBlockElement";
    private static final String LIST_STYLES = "listStyles";
    private static final String DOCUMENT_PARENT = "documentParent";
    public static final IgnoreElementRule IGNORE_ALL = new IgnoreElementRule(f -> false, true);
    private final Map<String, TagHandler> fMap;
    private final CommentHandler fCommentHandler;
    private TagContext fPeek;
    private final Deque<WikiScannerContext> fScannerContext = new ArrayDeque<WikiScannerContext>();
    private final Deque<Map<String, Object>> fStackParameters = new ArrayDeque<Map<String, Object>>();
    private Deque<IgnoreElementRule> fignoreElementRuleStack = new ArrayDeque<IgnoreElementRule>();
    private int fEmptyLineCount;
    private XhtmlCharacterType fPreviousCharType = null;
    private String characters;

    public TagStack(WikiScannerContext context, Map<String, TagHandler> handlers) {
        this(context, handlers, new CommentHandler());
    }

    public TagStack(WikiScannerContext context, Map<String, TagHandler> handlers, CommentHandler commentHandler) {
        this.fMap = handlers;
        this.fScannerContext.push(context);
        this.fCommentHandler = commentHandler;
        this.pushStackParameters();
    }

    public void beginElement(String name, WikiParameters params) {
        this.flushCharacters(false);
        this.fPeek = new TagContext(this.fPeek, name, params, this);
        name = this.fPeek.getName();
        TagHandler handler = this.fMap.get(name);
        this.switchIgnoreRule(this.fPeek, true);
        if (!this.shouldIgnoreElements()) {
            if (!(handler instanceof AbstractFormatTagHandler)) {
                this.fPreviousCharType = null;
            }
            this.fPeek.beginElement(handler);
        }
    }

    public void endElement() {
        this.flushCharacters(true);
        if (!this.shouldIgnoreElements()) {
            this.fPeek.endElement();
        }
        this.switchIgnoreRule(this.fPeek, false);
        this.fPeek = this.fPeek.getParentContext();
    }

    private XhtmlCharacterType getCharacterType(char ch, XhtmlCharacterType prevCharType, boolean beforeEnd) {
        XhtmlCharacterType type = XhtmlCharacterType.CHARACTER;
        switch (ch) {
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                type = XhtmlCharacterType.SPECIAL_SYMBOL;
                break;
            }
            case '\t': 
            case ' ': {
                type = XhtmlCharacterType.SPACE;
                break;
            }
            case '\u00a0': {
                if (prevCharType == XhtmlCharacterType.SPACE || prevCharType == null || beforeEnd) {
                    type = XhtmlCharacterType.SPACE;
                    break;
                }
                type = XhtmlCharacterType.CHARACTER;
                break;
            }
            case '\n': 
            case '\r': {
                type = XhtmlCharacterType.NEW_LINE;
                break;
            }
        }
        return type;
    }

    public WikiScannerContext getScannerContext() {
        return this.fScannerContext.isEmpty() ? null : this.fScannerContext.peek();
    }

    public void setScannerContext(WikiScannerContext context) {
        if (!this.fScannerContext.isEmpty()) {
            this.fScannerContext.pop();
        }
        this.fScannerContext.push(context);
    }

    public void pushScannerContext(WikiScannerContext context) {
        this.fScannerContext.push(context);
    }

    public WikiScannerContext popScannerContext() {
        return this.fScannerContext.pop();
    }

    private void flushStack(Queue<XhtmlCharacter> stack) {
        block6: while (!stack.isEmpty()) {
            XhtmlCharacter character = stack.poll();
            switch (character.getType()) {
                case ESCAPED: {
                    this.getScannerContext().onEscape("" + character.getCharacter());
                    continue block6;
                }
                case SPECIAL_SYMBOL: {
                    this.getScannerContext().onSpecialSymbol("" + character.getCharacter());
                    continue block6;
                }
                case NEW_LINE: {
                    this.getScannerContext().onLineBreak();
                    continue block6;
                }
                case SPACE: {
                    StringBuilder spaceBuffer = new StringBuilder(" ");
                    while (!stack.isEmpty() && stack.element().getType() == XhtmlCharacterType.SPACE) {
                        stack.poll();
                        spaceBuffer.append(' ');
                    }
                    this.getScannerContext().onSpace(spaceBuffer.toString());
                    continue block6;
                }
            }
            StringBuilder charBuffer = new StringBuilder();
            charBuffer.append(character.getCharacter());
            while (!stack.isEmpty() && stack.element().getType() == XhtmlCharacterType.CHARACTER) {
                charBuffer.append(stack.poll().getCharacter());
            }
            this.getScannerContext().onWord(WikiPageUtil.escapeXmlString(charBuffer.toString()));
        }
    }

    public void onCharacters(String content) {
        if (!this.fPeek.isContentContainer() || this.shouldIgnoreElements()) {
            return;
        }
        if (!this.fPeek.appendContent(content)) {
            this.flushCharacters(false);
            this.characters = content;
            if (!StringUtils.contains((CharSequence)content, (int)160)) {
                this.flushCharacters(false);
            }
        }
    }

    private void flushCharacters(boolean beforeEnd) {
        if (this.characters != null) {
            ArrayDeque<XhtmlCharacter> stack = new ArrayDeque<XhtmlCharacter>();
            for (int i = 0; i < this.characters.length(); ++i) {
                char c = this.characters.charAt(i);
                this.fPreviousCharType = this.getCharacterType(c, this.fPreviousCharType, this.characters.length() == i + 1 && beforeEnd);
                stack.offer(new XhtmlCharacter(c, this.fPreviousCharType));
            }
            this.flushStack(stack);
            this.characters = null;
        }
    }

    public void onComment(char[] array, int start, int length) {
        this.flushCharacters(false);
        this.fCommentHandler.onComment(new String(array, start, length), this);
    }

    public void pushStackParameters() {
        this.fStackParameters.push(new HashMap());
        this.setStackParameter(LIST_STYLES, new StringBuffer());
        this.setQuoteDepth(0);
        this.getStackParameters().put(INSIDE_BLOCK_ELEMENT, false);
        for (TagHandler tagElementHandler : this.fMap.values()) {
            tagElementHandler.initialize(this);
        }
    }

    public void popStackParameters() {
        this.fStackParameters.pop();
    }

    private Map<String, Object> getStackParameters() {
        return this.fStackParameters.peek();
    }

    public void setStackParameter(String name, Object data) {
        Deque set = (Deque)this.getStackParameters().get(name);
        if (set != null && !set.isEmpty()) {
            set.pop();
        }
        this.pushStackParameter(name, data);
    }

    public Object getStackParameter(String name) {
        Deque set = (Deque)this.getStackParameters().get(name);
        return set == null ? null : set.peek();
    }

    @Deprecated
    public Object getStackParameter(String name, int index) {
        Deque set = (Deque)this.getStackParameters().get(name);
        if (set == null || set.size() <= index) {
            return null;
        }
        return set.toArray()[set.size() - index - 1];
    }

    public Iterator<Object> getStackParameterIterator(String name) {
        Deque set = (Deque)this.getStackParameters().get(name);
        return set == null ? null : set.descendingIterator();
    }

    public void pushStackParameter(String name, Object data) {
        LinkedList<Object> set = (LinkedList<Object>)this.getStackParameters().get(name);
        if (set == null) {
            set = new LinkedList<Object>();
            this.getStackParameters().put(name, set);
        }
        set.push(data);
    }

    public Object popStackParameter(String name) {
        return ((Deque)this.getStackParameters().get(name)).pop();
    }

    public void setQuoteDepth(int depth) {
        this.setStackParameter(QUOTE_DEPTH, depth);
    }

    public int getQuoteDepth() {
        return (Integer)this.getStackParameter(QUOTE_DEPTH);
    }

    public boolean isInsideBlockElement() {
        return (Boolean)this.getStackParameters().get(INSIDE_BLOCK_ELEMENT);
    }

    public void setInsideBlockElement() {
        this.getStackParameters().put(INSIDE_BLOCK_ELEMENT, true);
    }

    public void unsetInsideBlockElement() {
        this.getStackParameters().put(INSIDE_BLOCK_ELEMENT, false);
    }

    public void setDocumentParent() {
        this.getStackParameters().put(DOCUMENT_PARENT, this.fPeek.getParent());
    }

    public TagContext getDocumentParent() {
        return (TagContext)this.getStackParameters().get(DOCUMENT_PARENT);
    }

    public String pushListStyle(char style) {
        StringBuffer listStyles = (StringBuffer)this.getStackParameter(LIST_STYLES);
        listStyles.append(style);
        return listStyles.toString();
    }

    public void popListStyle() {
        StringBuffer listStyles = (StringBuffer)this.getStackParameter(LIST_STYLES);
        if (listStyles.length() > 0) {
            listStyles.setLength(listStyles.length() - 1);
        }
    }

    public boolean isEndOfList() {
        return ((StringBuffer)this.getStackParameter(LIST_STYLES)).length() == 0;
    }

    public void resetEmptyLinesCount() {
        this.fEmptyLineCount = 0;
    }

    public void incrementEmptyLinesCount() {
        ++this.fEmptyLineCount;
    }

    public int getEmptyLinesCount() {
        return this.fEmptyLineCount;
    }

    public boolean shouldIgnoreElements() {
        return !this.fignoreElementRuleStack.isEmpty() && this.fignoreElementRuleStack.peek().isActive();
    }

    public void setIgnoreElements() {
        this.pushIgnoreElementRule(IGNORE_ALL);
    }

    public void unsetIgnoreElements() {
        this.popIgnoreElementRule();
    }

    public void pushIgnoreElementRule(IgnoreElementRule ignoreElementRule) {
        this.fignoreElementRuleStack.push(ignoreElementRule);
    }

    public IgnoreElementRule popIgnoreElementRule() {
        return this.fignoreElementRuleStack.pop();
    }

    private void switchIgnoreRule(TagContext fPeek, boolean begin) {
        if (!this.fignoreElementRuleStack.isEmpty()) {
            this.fignoreElementRuleStack.peek().switchRule(fPeek, begin);
        }
    }
}

