/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml;

import org.xwiki.rendering.wikimodel.IWikiPrinter;
import org.xwiki.rendering.wikimodel.PrintTextListener;
import org.xwiki.rendering.wikimodel.ReferenceHandler;
import org.xwiki.rendering.wikimodel.WikiFormat;
import org.xwiki.rendering.wikimodel.WikiPageUtil;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.util.WikiEntityUtil;

public class PrintInlineListener
extends PrintTextListener {
    public PrintInlineListener(IWikiPrinter printer) {
        super(printer);
    }

    public PrintInlineListener(IWikiPrinter printer, boolean supportImage, boolean supportDownload) {
        super(printer, supportImage, supportDownload);
    }

    @Override
    public void beginFormat(WikiFormat format) {
        this.print(format.getTags(true));
        if (format.getParams().size() > 0) {
            this.print("<span class='wikimodel-parameters'" + String.valueOf(format.getParams()) + ">");
        }
    }

    @Override
    public void beginPropertyInline(String str) {
        this.print("<span class='wikimodel-property' url='" + WikiPageUtil.escapeXmlAttribute(str) + "'>");
    }

    @Override
    public void endFormat(WikiFormat format) {
        if (format.getParams().size() > 0) {
            this.print("</span>");
        }
        this.print(format.getTags(false));
    }

    @Override
    public void endPropertyInline(String inlineProperty) {
        this.print("</span>");
    }

    protected String getSymbolEntity(String str) {
        Object entity = null;
        if (this.isHtmlEntities()) {
            entity = WikiEntityUtil.getHtmlSymbol(str);
        } else {
            int code = WikiEntityUtil.getHtmlCodeByWikiSymbol(str);
            if (code > 0) {
                entity = "#" + Integer.toString(code);
            }
        }
        if (entity != null) {
            entity = "&" + (String)entity + ";";
            if (str.startsWith(" --")) {
                entity = "&#160;" + (String)entity + " ";
            }
        }
        return entity;
    }

    protected boolean isHtmlEntities() {
        return true;
    }

    @Override
    protected ReferenceHandler newReferenceHandler() {
        return new ReferenceHandler(this.isSupportImage(), this.isSupportDownload()){

            @Override
            protected void handleImage(String ref, String label, WikiParameters params) {
                PrintInlineListener.this.print("<img src='" + WikiPageUtil.escapeXmlAttribute(ref) + "'" + String.valueOf(params) + "/>");
            }

            @Override
            protected void handleReference(String ref, String label, WikiParameters params) {
                PrintInlineListener.this.print("<a href='" + WikiPageUtil.escapeXmlAttribute(ref) + "'" + String.valueOf(params) + ">" + WikiPageUtil.escapeXmlString(label) + "</a>");
            }
        };
    }

    @Override
    public void onEscape(String str) {
        this.print("<span class='wikimodel-escaped'>" + WikiPageUtil.escapeXmlString(str) + "</span>");
    }

    @Override
    public void onExtensionInline(String extensionName, WikiParameters params) {
        this.print("<span class='wikimodel-extension' extension='" + extensionName + "'" + String.valueOf(params) + "/>");
    }

    @Override
    public void onLineBreak() {
        this.print("<br />");
    }

    @Override
    public void onSpecialSymbol(String str) {
        String entity = this.getSymbolEntity(str);
        if (entity == null) {
            entity = WikiPageUtil.escapeXmlString(str);
        }
        this.print(entity);
    }

    @Override
    public void onVerbatimInline(String str, WikiParameters params) {
        this.print("<tt class=\"wikimodel-verbatim\"" + String.valueOf(params) + ">" + WikiPageUtil.escapeXmlString(str) + "</tt>");
    }
}

