/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.internal.renderer.xwiki20.ListItemStackingInlineContentChainingListener;
import org.xwiki.rendering.internal.renderer.xwiki20.StackingFigureContentChainingListener;
import org.xwiki.rendering.internal.renderer.xwiki20.TableCellStackingInlineContentChainingListener;
import org.xwiki.rendering.internal.renderer.xwiki20.TableHeadCellStackingInlineContentChainingListener;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxEscapeWikiPrinter;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxListenerChain;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxMacroRenderer;
import org.xwiki.rendering.internal.renderer.xwiki20.reference.XWikiSyntaxResourceRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.EventType;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.LookaheadChainingListener;
import org.xwiki.rendering.listener.chaining.StackableChainingListener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.VoidWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;

public class XWikiSyntaxChainingRenderer
extends AbstractChainingPrintRenderer
implements StackableChainingListener {
    private static final String EMPTY_PARAMETERS = "(%%)";
    private static final EnumSet<BlockStateChainingListener.Event> NEWLINE_HIDING_ELEMENTS = EnumSet.of(BlockStateChainingListener.Event.TABLE, BlockStateChainingListener.Event.LIST, BlockStateChainingListener.Event.DEFINITION_LIST);
    private XWikiSyntaxResourceRenderer linkResourceRenderer;
    private XWikiSyntaxResourceRenderer imageResourceRenderer;
    private XWikiSyntaxMacroRenderer macroPrinter;
    protected ResourceReferenceSerializer linkReferenceSerializer;
    protected ResourceReferenceSerializer imageReferenceSerializer;
    private boolean isFirstElementRendered;
    private StringBuilder listStyle = new StringBuilder();
    private Map<String, String> previousFormatParameters;
    private String figureCaption;

    public XWikiSyntaxChainingRenderer(ListenerChain listenerChain, ResourceReferenceSerializer linkReferenceSerializer, ResourceReferenceSerializer imageReferenceSerializer) {
        this.setListenerChain(listenerChain);
        this.linkReferenceSerializer = linkReferenceSerializer;
        this.imageReferenceSerializer = imageReferenceSerializer;
        this.linkResourceRenderer = this.createXWikiSyntaxLinkRenderer(this.getListenerChain(), linkReferenceSerializer);
        this.imageResourceRenderer = this.createXWikiSyntaxImageRenderer(this.getListenerChain(), imageReferenceSerializer);
        this.macroPrinter = new XWikiSyntaxMacroRenderer();
    }

    protected XWikiSyntaxResourceRenderer createXWikiSyntaxLinkRenderer(ListenerChain listenerChain, ResourceReferenceSerializer linkReferenceSerializer) {
        return new XWikiSyntaxResourceRenderer((XWikiSyntaxListenerChain)listenerChain, linkReferenceSerializer);
    }

    protected XWikiSyntaxResourceRenderer createXWikiSyntaxImageRenderer(ListenerChain listenerChain, ResourceReferenceSerializer imageReferenceSerializer) {
        return new XWikiSyntaxResourceRenderer((XWikiSyntaxListenerChain)listenerChain, imageReferenceSerializer);
    }

    private BlockStateChainingListener getBlockState() {
        return this.getXWikiSyntaxListenerChain().getBlockStateChainingListener();
    }

    public StackableChainingListener createChainingListenerInstance() {
        XWikiSyntaxChainingRenderer renderer = new XWikiSyntaxChainingRenderer(this.getListenerChain(), this.linkReferenceSerializer, this.imageReferenceSerializer);
        renderer.setPrinter(this.getPrinter());
        return renderer;
    }

    private XWikiSyntaxListenerChain getXWikiSyntaxListenerChain() {
        return (XWikiSyntaxListenerChain)this.getListenerChain();
    }

    private XWikiSyntaxResourceRenderer getLinkRenderer() {
        return this.linkResourceRenderer;
    }

    private XWikiSyntaxResourceRenderer getImageRenderer() {
        return this.imageResourceRenderer;
    }

    private XWikiSyntaxMacroRenderer getMacroPrinter() {
        return this.macroPrinter;
    }

    public void beginGroup(Map<String, String> parameters) {
        if (!this.getBlockState().isInLine()) {
            this.printEmptyLine();
        }
        if (parameters.size() > 0) {
            this.printParameters(parameters, true);
        }
        this.print("(((");
        this.print("\n");
        this.getListenerChain().pushAllStackableListeners();
    }

    public void endDocument(MetaData metadata) {
        this.getXWikiPrinter().flush();
    }

    public void endGroup(Map<String, String> parameters) {
        this.print("\n");
        this.print(")))");
        this.getListenerChain().popAllStackableListeners();
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        if (this.getLinkRenderer().forceFullSyntax(this.getXWikiPrinter(), freestanding, parameters) && this.getXWikiPrinter().getBuffer().length() > 0 && this.getXWikiPrinter().getBuffer().charAt(this.getXWikiPrinter().getBuffer().length() - 1) == '[') {
            this.getXWikiPrinter().setEscapeLastChar(true);
        }
        this.handleEmptyParameters();
        this.getXWikiPrinter().flush();
        this.getLinkRenderer().beginRenderLink(this.getXWikiPrinter(), freestanding, parameters);
        XWikiSyntaxEscapeWikiPrinter linkLabelPrinter = new XWikiSyntaxEscapeWikiPrinter((WikiPrinter)new DefaultWikiPrinter(), this.getXWikiSyntaxListenerChain());
        linkLabelPrinter.setOnNewLine(this.getXWikiPrinter().isOnNewLine());
        this.pushPrinter((WikiPrinter)linkLabelPrinter);
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        XWikiSyntaxEscapeWikiPrinter linkBlocksPrinter = this.getXWikiPrinter();
        linkBlocksPrinter.flush();
        String content = linkBlocksPrinter.toString();
        this.popPrinter();
        this.getLinkRenderer().renderLinkContent(this.getXWikiPrinter(), content);
        this.getLinkRenderer().endRenderLink(this.getXWikiPrinter(), reference, freestanding, parameters);
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        if (this.previousFormatParameters != null) {
            if (!parameters.isEmpty()) {
                if (!this.previousFormatParameters.equals(parameters)) {
                    this.previousFormatParameters = null;
                    this.printParameters(parameters, false);
                } else {
                    this.previousFormatParameters = null;
                }
            }
        } else if (this.previousFormatParameters == null) {
            this.printParameters(parameters, false);
        }
        switch (format) {
            case BOLD: {
                this.handleEmptyParameters();
                this.getXWikiPrinter().printBeginBold();
                break;
            }
            case ITALIC: {
                this.handleEmptyParameters();
                this.getXWikiPrinter().printBeginItalic();
                break;
            }
            case STRIKEDOUT: {
                this.print("--");
                break;
            }
            case UNDERLINED: {
                this.print("__");
                break;
            }
            case SUPERSCRIPT: {
                this.print("^^");
                break;
            }
            case SUBSCRIPT: {
                this.print(",,");
                break;
            }
            case MONOSPACE: {
                this.print("##");
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.print("**");
                break;
            }
            case ITALIC: {
                this.getXWikiPrinter().printEndItalic();
                break;
            }
            case STRIKEDOUT: {
                this.print("--");
                break;
            }
            case UNDERLINED: {
                this.print("__");
                break;
            }
            case SUPERSCRIPT: {
                this.print("^^");
                break;
            }
            case SUBSCRIPT: {
                this.print(",,");
                break;
            }
            case MONOSPACE: {
                this.print("##");
                break;
            }
            case NONE: {
                break;
            }
        }
        if (!parameters.isEmpty()) {
            this.previousFormatParameters = parameters;
        }
    }

    private void handleEmptyParameters() {
        if (this.previousFormatParameters != null) {
            this.getPrinter().print(EMPTY_PARAMETERS);
            this.previousFormatParameters = null;
        }
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
    }

    public void endParagraph(Map<String, String> parameters) {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void onNewLine() {
        if (this.getBlockState().isInLine()) {
            if (this.getXWikiSyntaxListenerChain().getConsecutiveNewLineStateChainingListener().getNewLineCount() > 1) {
                this.print("\\\\");
            } else {
                LookaheadChainingListener lookaheadListener = this.getXWikiSyntaxListenerChain().getLookaheadChainingListener();
                QueueListener.Event nextEvent = lookaheadListener.getNextEvent();
                if (nextEvent.eventType.isInlineEnd() || nextEvent.eventType == EventType.END_FORMAT && nextEvent.eventParameters[0] == Format.NONE && lookaheadListener.getNextEvent((int)2).eventType.isInlineEnd()) {
                    this.print("\\\\");
                } else {
                    this.print("\n");
                }
            }
        } else {
            this.print("\n");
        }
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean inline) {
        if (!inline) {
            this.printEmptyLine();
            this.print(this.getMacroPrinter().renderMacro(id, parameters, content, inline));
        } else {
            this.getXWikiPrinter().printInlineMacro(this.getMacroPrinter().renderMacro(id, parameters, content, inline));
        }
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
        this.print(StringUtils.repeat((String)"=", (int)level.getAsInt()) + " ");
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.print(" " + StringUtils.repeat((String)"=", (int)level.getAsInt()));
    }

    public void onWord(String word) {
        this.printDelayed(word);
    }

    public void onSpace() {
        this.printDelayed(" ");
    }

    public void onSpecialSymbol(char symbol) {
        this.printDelayed("" + symbol);
    }

    public void beginList(ListType type, Map<String, String> parameters) {
        this.previousFormatParameters = null;
        if (this.getBlockState().getListDepth() == 1) {
            this.printEmptyLine();
        } else {
            this.getPrinter().print("\n");
        }
        if (type == ListType.BULLETED) {
            this.listStyle.append("*");
        } else {
            this.listStyle.append("1");
        }
        this.printParameters(parameters);
    }

    public void beginListItem() {
        if (this.getBlockState().getListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        this.print(this.listStyle.toString());
        if (StringUtils.contains((CharSequence)this.listStyle.toString(), (int)49)) {
            this.print(".");
        }
        this.print(" ");
        this.getXWikiSyntaxListenerChain().addListener((ChainingListener)new ListItemStackingInlineContentChainingListener(this.getListenerChain()), this.getListenerChain().indexOf(LookaheadChainingListener.class) + 1);
    }

    public void beginListItem(Map<String, String> parameters) {
        this.beginListItem();
    }

    public void endList(ListType type, Map<String, String> parameters) {
        this.listStyle.setLength(this.listStyle.length() - 1);
        this.getXWikiPrinter().flush();
    }

    public void endListItem() {
        this.previousFormatParameters = null;
        this.getXWikiSyntaxListenerChain().removeListener(ListItemStackingInlineContentChainingListener.class);
        this.getXWikiPrinter().flush();
    }

    public void endListItem(Map<String, String> parameters) {
        this.endListItem();
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        if (!isInline) {
            this.printEmptyLine();
        }
        this.handleEmptyParameters();
        this.pushPrinter((WikiPrinter)new XWikiSyntaxEscapeWikiPrinter((WikiPrinter)VoidWikiPrinter.VOIDWIKIPRINTER, this.getXWikiSyntaxListenerChain()));
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.previousFormatParameters = null;
        this.popPrinter();
        this.print(this.getMacroPrinter().renderMacro(name, parameters, content, isInline));
    }

    public void onId(String name) {
        this.print("{{id name=\"" + name + "\"/}}");
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
        this.print("----");
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        if (!inline) {
            this.printEmptyLine();
        }
        this.printParameters(parameters);
        this.print("{{{");
        this.getXWikiPrinter().printVerbatimContent(content);
        this.print("}}}");
    }

    public void onEmptyLines(int count) {
        QueueListener.Event nextEvent;
        int newLinesToPrint = count;
        BlockStateChainingListener.Event previousEvent = this.getBlockState().getPreviousEvent();
        if (previousEvent != null && NEWLINE_HIDING_ELEMENTS.contains(previousEvent)) {
            ++newLinesToPrint;
        }
        if ((nextEvent = this.getXWikiSyntaxListenerChain().getLookaheadChainingListener().getNextEvent()) != null) {
            if (previousEvent == BlockStateChainingListener.Event.NONE) {
                newLinesToPrint = nextEvent.eventType == EventType.END_GROUP ? --newLinesToPrint : ++newLinesToPrint;
                if (this.getListenerChain().getStackingDepth() == 0 && nextEvent.eventType != EventType.END_DOCUMENT) {
                    ++newLinesToPrint;
                }
            } else if (nextEvent.eventType == EventType.END_DOCUMENT) {
                ++newLinesToPrint;
            }
        }
        if (newLinesToPrint > 0) {
            this.print(StringUtils.repeat((char)'\n', (int)newLinesToPrint));
        }
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        if (this.getBlockState().getDefinitionListDepth() == 1 && !this.getBlockState().isInList()) {
            this.printEmptyLine();
        } else {
            this.print("\n");
        }
        this.printParameters(parameters);
    }

    public void beginDefinitionTerm() {
        if (this.getBlockState().getDefinitionListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        if (this.listStyle.length() > 0) {
            this.print(this.listStyle.toString());
            if (this.listStyle.charAt(0) == '1') {
                this.print(".");
            }
        }
        this.print(StringUtils.repeat((char)':', (int)(this.getBlockState().getDefinitionListDepth() - 1)));
        this.print("; ");
    }

    public void beginDefinitionDescription() {
        if (this.getBlockState().getDefinitionListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        if (this.listStyle.length() > 0) {
            this.print(this.listStyle.toString());
            if (this.listStyle.charAt(0) == '1') {
                this.print(".");
            }
        }
        this.print(StringUtils.repeat((char)':', (int)(this.getBlockState().getDefinitionListDepth() - 1)));
        this.print(": ");
    }

    public void endDefinitionDescription() {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void endDefinitionTerm() {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void beginQuotation(Map<String, String> parameters) {
        if (!this.getBlockState().isInQuotationLine()) {
            this.printEmptyLine();
        }
        if (!parameters.isEmpty()) {
            this.printParameters(parameters);
        }
    }

    public void beginQuotationLine() {
        if (this.getBlockState().getQuotationLineIndex() > 0) {
            this.getPrinter().print("\n");
        }
        this.print(StringUtils.repeat((char)'>', (int)this.getBlockState().getQuotationDepth()));
    }

    public void endQuotationLine() {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void beginTable(Map<String, String> parameters) {
        this.printEmptyLine();
        if (!parameters.isEmpty()) {
            this.printParameters(parameters);
        }
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.print("|");
        if (!parameters.isEmpty()) {
            this.printParameters(parameters, false);
        } else {
            int parameterLength;
            QueueListener.Event nextEvent = this.getXWikiSyntaxListenerChain().getLookaheadChainingListener().getNextEvent();
            boolean isFormatOrGroup = nextEvent != null && (EventType.BEGIN_FORMAT.equals((Object)nextEvent.eventType) || EventType.BEGIN_GROUP.equals((Object)nextEvent.eventType));
            int n = parameterLength = isFormatOrGroup ? nextEvent.eventParameters.length : 0;
            if (isFormatOrGroup && parameterLength > 0 && nextEvent.eventParameters[parameterLength - 1] instanceof Map && !((Map)nextEvent.eventParameters[parameterLength - 1]).isEmpty()) {
                this.print(EMPTY_PARAMETERS);
            }
        }
        this.getXWikiSyntaxListenerChain().addListener((ChainingListener)new TableCellStackingInlineContentChainingListener(this.getListenerChain()), this.getListenerChain().indexOf(LookaheadChainingListener.class) + 1);
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.print("|=");
        this.printParameters(parameters, false);
        this.getXWikiSyntaxListenerChain().addListener((ChainingListener)new TableHeadCellStackingInlineContentChainingListener(this.getListenerChain()), this.getListenerChain().indexOf(LookaheadChainingListener.class) + 1);
    }

    public void beginTableRow(Map<String, String> parameters) {
        if (this.getBlockState().getCellRow() > 0) {
            this.print("\n");
        }
        this.printParameters(parameters, false);
    }

    public void endTableCell(Map<String, String> parameters) {
        this.previousFormatParameters = null;
        this.getXWikiSyntaxListenerChain().removeListener(TableCellStackingInlineContentChainingListener.class);
        this.getXWikiPrinter().flush();
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.previousFormatParameters = null;
        this.getXWikiSyntaxListenerChain().removeListener(TableHeadCellStackingInlineContentChainingListener.class);
    }

    public void beginFigure(Map<String, String> parameters) {
        StackingFigureContentChainingListener figureContent = (StackingFigureContentChainingListener)this.getXWikiSyntaxListenerChain().getListener(StackingFigureContentChainingListener.class);
        if (figureContent != null) {
            if (figureContent.isCleanImageFigure()) {
                this.figureCaption = null;
                LinkedHashMap<String, String> adaptedParameters = new LinkedHashMap<String, String>(parameters);
                adaptedParameters.computeIfPresent("class", (k, v) -> Arrays.stream(StringUtils.split((String)v)).filter(Predicate.isEqual("image").negate()).collect(Collectors.collectingAndThen(Collectors.joining(" "), s -> s.isEmpty() ? null : s)));
                this.beginParagraph(adaptedParameters);
                if (figureContent.isWrappedInLink()) {
                    this.getBlockState().beginLink(figureContent.getLinkReference(), false, figureContent.getLinkParameters());
                }
                this.getImageRenderer().beginRenderLink(this.getXWikiPrinter(), false, figureContent.getImageParameters());
                this.pushPrinter((WikiPrinter)new XWikiSyntaxEscapeWikiPrinter((WikiPrinter)VoidWikiPrinter.VOIDWIKIPRINTER, this.getXWikiSyntaxListenerChain()));
            }
        } else {
            figureContent = new StackingFigureContentChainingListener(this.getListenerChain());
            this.getXWikiSyntaxListenerChain().addListener((ChainingListener)figureContent, this.getListenerChain().indexOf(LookaheadChainingListener.class) + 1);
            figureContent.beginFigure(parameters);
        }
    }

    public void beginFigureCaption(Map<String, String> parameters) {
        StackingFigureContentChainingListener figureContent = (StackingFigureContentChainingListener)this.getXWikiSyntaxListenerChain().getListener(StackingFigureContentChainingListener.class);
        if (figureContent != null && figureContent.isCleanImageFigure()) {
            this.isFirstElementRendered = false;
            this.pushPrinter((WikiPrinter)new XWikiSyntaxEscapeWikiPrinter((WikiPrinter)new DefaultWikiPrinter(), this.getXWikiSyntaxListenerChain()));
        }
    }

    public void endFigureCaption(Map<String, String> parameters) {
        StackingFigureContentChainingListener figureContent = (StackingFigureContentChainingListener)this.getXWikiSyntaxListenerChain().getListener(StackingFigureContentChainingListener.class);
        if (figureContent != null && figureContent.isCleanImageFigure()) {
            XWikiSyntaxEscapeWikiPrinter figureCaptionPrinter = this.getXWikiPrinter();
            figureCaptionPrinter.flush();
            String content = figureCaptionPrinter.toString();
            this.popPrinter();
            this.figureCaption = content;
        }
    }

    public void endFigure(Map<String, String> parameters) {
        StackingFigureContentChainingListener figureContent = (StackingFigureContentChainingListener)this.getXWikiSyntaxListenerChain().getListener(StackingFigureContentChainingListener.class);
        if (figureContent != null) {
            this.getListenerChain().removeListener(StackingFigureContentChainingListener.class);
            if (figureContent.isCleanImageFigure()) {
                XWikiSyntaxEscapeWikiPrinter figurePrinter = this.getXWikiPrinter();
                figurePrinter.flush();
                this.popPrinter();
                this.isFirstElementRendered = true;
                if (this.figureCaption != null) {
                    this.getImageRenderer().renderLinkContent(this.getXWikiPrinter(), this.figureCaption);
                }
                this.getImageRenderer().endRenderLink(this.getXWikiPrinter(), figureContent.getImageReference(), false, figureContent.getImageParameters());
                if (figureContent.isWrappedInLink()) {
                    this.getBlockState().endLink(figureContent.getLinkReference(), false, figureContent.getLinkParameters());
                }
                this.endParagraph(parameters);
            }
        }
    }

    public void onImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.getImageRenderer().beginRenderLink(this.getXWikiPrinter(), freestanding, parameters);
        this.getImageRenderer().endRenderLink(this.getXWikiPrinter(), reference, freestanding, parameters);
    }

    protected void printParameters(Map<String, String> parameters) {
        this.printParameters(parameters, true);
    }

    protected void printParameters(Map<String, String> parameters, boolean newLine) {
        StringBuilder parametersStr = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (key == null || value == null) continue;
            value = value.replaceAll("[~\"]", "~$0");
            value = value.replace("%)", "~%)");
            parametersStr.append(' ').append(key).append('=').append('\"').append(value).append('\"');
        }
        if (parametersStr.length() > 0) {
            StringBuilder buffer = new StringBuilder("(%");
            buffer.append((CharSequence)parametersStr);
            buffer.append(" %)");
            if (newLine) {
                buffer.append('\n');
            }
            this.print(buffer.toString());
        }
    }

    private void printDelayed(String text) {
        this.print(text, true);
    }

    private void print(String text) {
        this.print(text, false);
    }

    private void print(String text, boolean isDelayed) {
        if (!StringUtils.containsOnly((CharSequence)text, (char[])new char[]{'\n'})) {
            this.isFirstElementRendered = true;
        }
        this.handleEmptyParameters();
        if (isDelayed) {
            this.getXWikiPrinter().printDelayed(text);
        } else {
            this.getPrinter().print(text);
        }
    }

    private void printEmptyLine() {
        if (this.isFirstElementRendered) {
            this.print("\n\n");
        } else {
            this.isFirstElementRendered = true;
        }
    }

    public void setPrinter(WikiPrinter printer) {
        if (printer instanceof XWikiSyntaxEscapeWikiPrinter) {
            super.setPrinter(printer);
        } else {
            super.setPrinter((WikiPrinter)new XWikiSyntaxEscapeWikiPrinter(printer, (XWikiSyntaxListenerChain)this.getListenerChain()));
        }
    }

    public XWikiSyntaxEscapeWikiPrinter getXWikiPrinter() {
        return (XWikiSyntaxEscapeWikiPrinter)super.getPrinter();
    }

    protected void popPrinter() {
        this.getXWikiPrinter().flush();
        super.popPrinter();
    }
}

