/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.chaining.EventType;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.LookaheadChainingListener;

public abstract class AbstractStackingInlineContentChainingListener
extends LookaheadChainingListener {
    private boolean isStacking;
    private int standaloneElementDepth;
    private int standaloneTopLevelElements;
    private boolean hasGroupTopLevelBlock;

    public AbstractStackingInlineContentChainingListener(ListenerChain listenerChain) {
        super(listenerChain, Integer.MAX_VALUE);
        this.setListenerChain(listenerChain);
        this.isStacking = true;
    }

    public void beginGroup(Map<String, String> parameters) {
        if (this.standaloneElementDepth == 0) {
            this.hasGroupTopLevelBlock = true;
        }
        this.startStandaloneElement();
        super.beginGroup(parameters);
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.startStandaloneElement();
        super.beginHeader(level, id, parameters);
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.startStandaloneElement();
        super.beginParagraph(parameters);
    }

    public void beginQuotation(Map<String, String> parameters) {
        this.startStandaloneElement();
        super.beginQuotation(parameters);
    }

    public void beginTable(Map<String, String> parameters) {
        this.startStandaloneElement();
        super.beginTable(parameters);
    }

    public void beginFigure(Map<String, String> parameters) {
        this.startStandaloneElement();
        super.beginFigure(parameters);
    }

    public void beginFigureCaption(Map<String, String> parameters) {
        this.startStandaloneElement();
        super.beginFigureCaption(parameters);
    }

    public void endGroup(Map<String, String> parameters) {
        super.endGroup(parameters);
        this.endStandaloneElement();
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        super.endHeader(level, id, parameters);
        this.endStandaloneElement();
    }

    public void endParagraph(Map<String, String> parameters) {
        super.endParagraph(parameters);
        this.endStandaloneElement();
    }

    public void endQuotation(Map<String, String> parameters) {
        super.endQuotation(parameters);
        this.endStandaloneElement();
    }

    public void endTable(Map<String, String> parameters) {
        super.endTable(parameters);
        this.endStandaloneElement();
    }

    public void endFigure(Map<String, String> parameters) {
        super.endFigure(parameters);
        this.endStandaloneElement();
    }

    public void endFigureCaption(Map<String, String> parameters) {
        super.endFigureCaption(parameters);
        this.endStandaloneElement();
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        if (!inline) {
            this.startStandaloneElement();
        }
        super.onVerbatim(content, inline, parameters);
        if (!inline) {
            this.endStandaloneElement();
        }
    }

    protected void startStandaloneElement() {
        if (this.standaloneElementDepth == 0) {
            ++this.standaloneTopLevelElements;
        }
        ++this.standaloneElementDepth;
    }

    protected void endStandaloneElement() {
        --this.standaloneElementDepth;
    }

    private boolean shouldInsertGroupBlock() {
        return this.standaloneTopLevelElements > 0 && (this.standaloneTopLevelElements != 1 || !this.hasGroupTopLevelBlock);
    }

    protected void stopStacking() {
        if (this.isStacking) {
            this.setLookaheadDepth(0);
            this.isStacking = false;
            LookaheadChainingListener listener = (LookaheadChainingListener)this.getListenerChain().getListener(LookaheadChainingListener.class);
            QueueListener previousEvents = this.getPreviousEvents();
            if (this.shouldInsertGroupBlock()) {
                QueueListener queueListener = previousEvents;
                Objects.requireNonNull(queueListener);
                previousEvents.offerFirst((Object)new QueueListener.Event(queueListener, EventType.BEGIN_GROUP, new Object[]{Collections.emptyMap()}));
                int n = previousEvents.size() - 1;
                QueueListener queueListener2 = previousEvents;
                Objects.requireNonNull(queueListener2);
                previousEvents.add(n, (Object)new QueueListener.Event(queueListener2, EventType.END_GROUP, new Object[]{Collections.emptyMap()}));
            }
            listener.transferStart(previousEvents);
        }
    }
}

