/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml5.wikimodel;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.xhtml.XHTMLParser;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiSpanTagHandler;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.xhtml.handler.TeletypeTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;

public class XHTML5SpanTagHandler
extends XWikiSpanTagHandler {
    private static final String CLASS = "class";
    private static final String MONOSPACE = "monospace";
    private final TeletypeTagHandler ttHandler = new TeletypeTagHandler();

    public XHTML5SpanTagHandler(ComponentManager componentManager, XHTMLParser parser) {
        super(componentManager, parser);
    }

    protected void begin(TagContext context) {
        TagContext ttContext = this.getMonospaceContext(context);
        if (ttContext != null) {
            this.ttHandler.beginElement(ttContext);
        } else {
            super.begin(context);
        }
    }

    protected void end(TagContext context) {
        TagContext ttContext = this.getMonospaceContext(context);
        if (ttContext != null) {
            this.ttHandler.endElement(ttContext);
        } else {
            super.end(context);
        }
    }

    private TagContext getMonospaceContext(TagContext context) {
        List<String> classList;
        WikiParameter param = context.getParams().getParameter(CLASS);
        if (param != null && ((classList = Arrays.asList(param.getValue().split(" "))).contains(MONOSPACE) || classList.contains("wikimodel-verbatim"))) {
            WikiParameters ttParams = MONOSPACE.equals(param.getValue()) ? context.getParams().remove(CLASS) : context.getParams().setParameter(CLASS, classList.stream().filter(Predicate.isEqual(MONOSPACE).negate()).collect(Collectors.joining(" ")));
            return new TagContext(context.getParentContext(), "tt", ttParams, context.getTagStack());
        }
        return null;
    }
}

