/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.listener.ListenerRegistry;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.WrappingListener;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;

@Component(roles={WikiModelParserListenerBuilder.class})
@Singleton
public class WikiModelParserListenerBuilder {
    @Inject
    private ListenerRegistry listenerRegistry;
    @Inject
    private SyntaxRegistry syntaxRegistry;
    @Inject
    private Logger logger;

    Listener buildListener(String roleHint, Listener listener) {
        ListenerChain chain = new ListenerChain();
        List listeners = this.listenerRegistry.getListeners(chain, "parse", this.getSyntax(roleHint));
        listeners.forEach(arg_0 -> ((ListenerChain)chain).addListener(arg_0));
        chain.addListener((ChainingListener)new ChainingWrappingListener(listener));
        return listeners.isEmpty() ? listener : (Listener)listeners.get(0);
    }

    private Syntax getSyntax(String roleHint) {
        Syntax syntax = null;
        try {
            syntax = this.syntaxRegistry.resolveSyntax(roleHint);
        }
        catch (ParseException e) {
            this.logger.warn("Failed to find syntax [{}] in the registry during parser initialization. Cause: [{}]", (Object)roleHint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return syntax;
    }

    private static class ChainingWrappingListener
    extends WrappingListener
    implements ChainingListener {
        protected ChainingWrappingListener(Listener listener) {
            this.setWrappedListener(listener);
        }

        public ListenerChain getListenerChain() {
            return null;
        }
    }
}

