/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.image;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;

@Component
@Named(value="annotated")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class AnnotatedXHTMLImageRenderer
implements XHTMLImageRenderer {
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceSerializer xhtmlMarkerSerializer;
    @Inject
    private XHTMLImageRenderer defaultImageRenderer;

    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.defaultImageRenderer.setXHTMLWikiPrinter(printer);
    }

    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.defaultImageRenderer.getXHTMLWikiPrinter();
    }

    public void onImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.onImage(reference, freestanding, null, parameters);
    }

    public void onImage(ResourceReference reference, boolean freestanding, String id, Map<String, String> parameters) {
        String comment = "startimage:" + this.xhtmlMarkerSerializer.serialize(reference);
        this.getXHTMLWikiPrinter().printXMLComment(comment, true);
        this.defaultImageRenderer.onImage(reference, freestanding, id, parameters);
        this.getXHTMLWikiPrinter().printXMLComment("stopimage");
    }
}

