/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.toc;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.macro.toc.TocTreeBuilder;
import org.xwiki.rendering.internal.macro.toc.TreeParameters;
import org.xwiki.rendering.internal.macro.toc.TreeParametersBuilder;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.toc.TocMacroParameters;
import org.xwiki.rendering.macro.toc.TocTreeBuilderFactory;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.wiki.WikiModel;
import org.xwiki.rendering.wiki.WikiModelException;

public abstract class AbstractTocMacro<T extends TocMacroParameters>
extends AbstractMacro<T> {
    private static final String DESCRIPTION = "Generates a Table Of Contents.";
    private TocTreeBuilder tocTreeBuilder;
    @Inject
    private Provider<WikiModel> wikiModelProvider;
    @Inject
    private TocTreeBuilderFactory tocTreeBuilderFactory;

    protected AbstractTocMacro(Class<T> parametersBeanClass) {
        super("Table Of Contents", DESCRIPTION, parametersBeanClass);
        this.setPriority(2000);
        this.setDefaultCategories(Set.of("Navigation"));
    }

    public void initialize() throws InitializationException {
        super.initialize();
        try {
            this.tocTreeBuilder = this.tocTreeBuilderFactory.build();
        }
        catch (ComponentLookupException e) {
            throw new InitializationException(String.format("Failed to initialize [%s]", TocTreeBuilder.class), (Throwable)e);
        }
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(T parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM rootBlock = null;
        WikiModel wikiModel = (WikiModel)this.wikiModelProvider.get();
        if (((TocMacroParameters)parameters).getReference() != null) {
            if (wikiModel != null) {
                ((TocMacroParameters)parameters).setScope(TocMacroParameters.Scope.PAGE);
                rootBlock = this.getXDOM((ResourceReference)new DocumentResourceReference(((TocMacroParameters)parameters).getReference()), wikiModel);
            } else {
                throw new MacroExecutionException("The \"reference\" parameter can only be used when a WikiModel implementation is available");
            }
        }
        TreeParametersBuilder builder = new TreeParametersBuilder();
        TreeParameters treeParameters = builder.build((Block)rootBlock, (TocMacroParameters)parameters, context);
        return this.tocTreeBuilder.build(treeParameters);
    }

    private XDOM getXDOM(ResourceReference reference, WikiModel wikiModel) throws MacroExecutionException {
        try {
            return wikiModel.getXDOM(reference);
        }
        catch (WikiModelException e) {
            throw new MacroExecutionException(String.format("Failed to get XDOM for [%s]", reference), (Throwable)e);
        }
    }

    public boolean isExecutionIsolated(T parameters, String content) {
        return true;
    }
}

