/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.message;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.internal.macro.message.MacroIconPrettyNameProvider;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.box.AbstractBoxMacro;
import org.xwiki.rendering.macro.box.BoxMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.message.MessageMacroParameters;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.IconProvider;

public abstract class AbstractMessageMacro
extends AbstractBoxMacro<MessageMacroParameters> {
    private String iconName;
    @Inject
    private IconProvider iconProvider;
    @Inject
    private MacroIconPrettyNameProvider iconPrettyNameProvider;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;

    public AbstractMessageMacro(String macroName, String macroDescription) {
        super(macroName, macroDescription, (ContentDescriptor)new DefaultContentDescriptor("Content of the message", true, Block.LIST_BLOCK_TYPE), MessageMacroParameters.class);
    }

    protected List<Block> parseContent(MessageMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List macroContent = this.getMacroContentParser().parse(content, context, false, context.isInline()).getChildren();
        return Collections.singletonList(new MetaDataBlock(macroContent, this.getNonGeneratedContentMetaData()));
    }

    protected void setIconName(String iconName) {
        this.iconName = iconName;
    }

    protected String getIconName() {
        return this.iconName;
    }

    protected String getClassProperty() {
        return super.getClassProperty() + " " + this.getDescriptor().getId().getId() + "message";
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        this.contentParser.prepareContentWiki(macroBlock);
    }

    public List<Block> execute(MessageMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List boxFoundation = super.execute((BoxMacroParameters)parameters, content, context);
        if (!boxFoundation.isEmpty() && this.getIconName() != null) {
            Block defaultBox = (Block)boxFoundation.get(0);
            if (parameters.isStatus()) {
                defaultBox.setParameter("role", "status");
            }
            if (!context.isInline()) {
                GroupBlock boxTextContent = new GroupBlock(defaultBox.getChildren());
                defaultBox.setChildren(List.of(boxTextContent));
            }
            Block iconBlock = this.getIconBlock();
            defaultBox.insertChildBefore(iconBlock, (Block)defaultBox.getChildren().get(0));
        }
        return boxFoundation;
    }

    private Block getIconBlock() throws MacroExecutionException {
        Block iconBlock = this.iconProvider.get(this.getIconName());
        String iconPrettyName = this.iconPrettyNameProvider.getIconPrettyName(this.getDescriptor().getId().getId());
        if (iconBlock.getClass() == ImageBlock.class) {
            iconBlock.setAttribute("alt", (Object)iconPrettyName);
        } else if (!iconPrettyName.isEmpty()) {
            try {
                FormatBlock iconAlternativeBlock = new FormatBlock(((Block)this.plainTextParser.parse((Reader)new StringReader(iconPrettyName)).getChildren().get(0)).getChildren(), Format.NONE);
                iconAlternativeBlock.setParameter("class", "sr-only");
                iconBlock = new CompositeBlock(List.of(iconBlock, iconAlternativeBlock));
            }
            catch (ParseException e) {
                throw new MacroExecutionException(String.format("Failed to parse icon pretty name [%s] to compute a text alternative", iconPrettyName), (Throwable)e);
            }
        }
        return iconBlock;
    }

    public boolean isExecutionIsolated(MessageMacroParameters parameters, String content) {
        return true;
    }
}

