/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.box;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.box.AbstractBoxMacro;
import org.xwiki.rendering.macro.box.BoxMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="box")
@Singleton
public class DefaultBoxMacro<P extends BoxMacroParameters>
extends AbstractBoxMacro<P> {
    private static final String DESCRIPTION = "Draw a box around provided content.";
    private static final String CONTENT_DESCRIPTION = "the content to put in the box";

    public DefaultBoxMacro() {
        super("Box", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false, Block.LIST_BLOCK_TYPE), BoxMacroParameters.class);
        this.setDefaultCategories(Set.of("Formatting"));
    }

    @Override
    protected List<Block> parseContent(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List children = this.getMacroContentParser().parse(content, context, false, context.isInline()).getChildren();
        return Collections.singletonList(new MetaDataBlock(children, this.getNonGeneratedContentMetaData()));
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        this.contentParser.prepareContentWiki(macroBlock);
    }

    public boolean isExecutionIsolated(P parameters, String content) {
        return true;
    }
}

