/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.descriptor;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.xwiki.properties.BeanDescriptor;
import org.xwiki.properties.PropertyDescriptor;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.descriptor.AbstractMacroDescriptorAspect;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultParameterDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;

public abstract class AbstractMacroDescriptor
implements MacroDescriptor {
    private MacroId id;
    private String name;
    private String description;
    private ContentDescriptor contentDescriptor;
    private BeanDescriptor parametersBeanDescriptor;
    private Set<String> defaultCategories;
    private boolean supportsInlineMode;
    private Map<String, ParameterDescriptor> parameterDescriptorMap;

    public AbstractMacroDescriptor(MacroId id, String name, String description, ContentDescriptor contentDescriptor, BeanDescriptor parametersBeanDescriptor) {
        this.parameterDescriptorMap = new LinkedHashMap<String, ParameterDescriptor>();
        this.id = id;
        this.name = name;
        this.description = description;
        this.contentDescriptor = contentDescriptor;
        this.parametersBeanDescriptor = parametersBeanDescriptor;
    }

    protected void extractParameterDescriptorMap() {
        for (PropertyDescriptor propertyDescriptor : this.parametersBeanDescriptor.getProperties()) {
            DefaultParameterDescriptor desc = new DefaultParameterDescriptor(propertyDescriptor);
            this.parameterDescriptorMap.put(desc.getId().toLowerCase(), desc);
        }
    }

    @Override
    public MacroId getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<?> getParametersBeanClass() {
        return null != this.parametersBeanDescriptor ? this.parametersBeanDescriptor.getBeanClass() : Object.class;
    }

    @Override
    public Map<String, ParameterDescriptor> getParameterDescriptorMap() {
        return null != this.parametersBeanDescriptor ? Collections.unmodifiableMap(this.parameterDescriptorMap) : Collections.emptyMap();
    }

    public void setDefaultCategories(Set<String> defaultCategories) {
        this.defaultCategories = defaultCategories;
    }

    @Override
    public Set<String> getDefaultCategories() {
        return this.defaultCategories;
    }

    @Override
    public boolean supportsInlineMode() {
        return this.supportsInlineMode;
    }

    public void setSupportsInlineMode(boolean supportsInlineMode) {
        this.supportsInlineMode = supportsInlineMode;
    }

    @Deprecated
    public AbstractMacroDescriptor(String string, String string2, ContentDescriptor contentDescriptor, BeanDescriptor beanDescriptor) {
        Object[] objectArray = AbstractMacroDescriptorAspect.ajc$preInterConstructor$org_xwiki_rendering_macro_descriptor_AbstractMacroDescriptorAspect$org_xwiki_rendering_macro_descriptor_AbstractMacroDescriptor(string, string2, contentDescriptor, beanDescriptor);
        this((MacroId)objectArray[0], (String)objectArray[1], (String)objectArray[2], (ContentDescriptor)objectArray[3], (BeanDescriptor)objectArray[4]);
        AbstractMacroDescriptorAspect.ajc$postInterConstructor$org_xwiki_rendering_macro_descriptor_AbstractMacroDescriptorAspect$org_xwiki_rendering_macro_descriptor_AbstractMacroDescriptor(this, (String)objectArray[5], (String)objectArray[6], (ContentDescriptor)objectArray[7], (BeanDescriptor)objectArray[8]);
    }

    public static /* synthetic */ ContentDescriptor ajc$get$contentDescriptor(AbstractMacroDescriptor abstractMacroDescriptor) {
        return abstractMacroDescriptor.contentDescriptor;
    }

    public static /* synthetic */ void ajc$set$contentDescriptor(AbstractMacroDescriptor abstractMacroDescriptor, ContentDescriptor contentDescriptor) {
        abstractMacroDescriptor.contentDescriptor = contentDescriptor;
    }

    public static /* synthetic */ Set ajc$get$defaultCategories(AbstractMacroDescriptor abstractMacroDescriptor) {
        return abstractMacroDescriptor.defaultCategories;
    }

    public static /* synthetic */ void ajc$set$defaultCategories(AbstractMacroDescriptor abstractMacroDescriptor, Set set) {
        abstractMacroDescriptor.defaultCategories = set;
    }

    public static /* synthetic */ String ajc$get$description(AbstractMacroDescriptor abstractMacroDescriptor) {
        return abstractMacroDescriptor.description;
    }

    public static /* synthetic */ void ajc$set$description(AbstractMacroDescriptor abstractMacroDescriptor, String string) {
        abstractMacroDescriptor.description = string;
    }

    public static /* synthetic */ String ajc$get$name(AbstractMacroDescriptor abstractMacroDescriptor) {
        return abstractMacroDescriptor.name;
    }

    public static /* synthetic */ void ajc$set$name(AbstractMacroDescriptor abstractMacroDescriptor, String string) {
        abstractMacroDescriptor.name = string;
    }

    public static /* synthetic */ BeanDescriptor ajc$get$parametersBeanDescriptor(AbstractMacroDescriptor abstractMacroDescriptor) {
        return abstractMacroDescriptor.parametersBeanDescriptor;
    }

    public static /* synthetic */ void ajc$set$parametersBeanDescriptor(AbstractMacroDescriptor abstractMacroDescriptor, BeanDescriptor beanDescriptor) {
        abstractMacroDescriptor.parametersBeanDescriptor = beanDescriptor;
    }

    @Override
    public String getDefaultCategory() {
        return AbstractMacroDescriptorAspect.ajc$interMethod$org_xwiki_rendering_macro_descriptor_AbstractMacroDescriptorAspect$org_xwiki_rendering_macro_descriptor_AbstractMacroDescriptor$getDefaultCategory(this);
    }

    @Deprecated(since="14.6RC1")
    public void setDefaultCategory(String string) {
        AbstractMacroDescriptorAspect.ajc$interMethod$org_xwiki_rendering_macro_descriptor_AbstractMacroDescriptorAspect$org_xwiki_rendering_macro_descriptor_AbstractMacroDescriptor$setDefaultCategory(this, string);
    }
}

