/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.properties.BeanManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.internal.transformation.macro.IsolatedExecutionConfiguration;
import org.xwiki.rendering.internal.transformation.macro.MacroErrorManager;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.MacroNotFoundException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.util.ErrorBlockGenerator;
import org.xwiki.text.XWikiToStringBuilder;

@Component
@Named(value="macro")
@Singleton
public class MacroTransformation
extends AbstractTransformation
implements Initializable {
    private static final String TM_UNKNOWNMACRO = "rendering.macro.error.unknown";
    private static final String TM_FAILEDMACRO = "rendering.macro.error.failed";
    private static final String TM_INVALIDMACRO = "rendering.macro.error.invalid";
    private static final String TM_STANDALONEMACRO = "rendering.macro.error.standalone";
    private static final String TM_INVALIDMACROPARAMETER = "rendering.macro.error.invalidParameter";
    private int maxRecursions = 1000;
    @Inject
    private MacroManager macroManager;
    @Inject
    private BeanManager beanManager;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private Logger logger;
    @Inject
    private ErrorBlockGenerator errorBlockGenerator;
    @Inject
    private IsolatedExecutionConfiguration isolatedExecutionConfiguration;
    private MacroErrorManager macroErrorManager;

    public void initialize() throws InitializationException {
        this.macroErrorManager = new MacroErrorManager(this.errorBlockGenerator);
    }

    public int getPriority() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void transform(Block rootBlock, TransformationContext context) throws TransformationException {
        macroContext = new MacroTransformationContext(context);
        macroContext.setTransformation((Transformation)this);
        priorityMacroBlockMatcher = new PriorityMacroBlockMatcher(context.getSyntax());
        recursions = 0;
        while (recursions < this.maxRecursions) {
            block16: {
                if (priorityMacroBlockMatcher.isFullScanNeeded()) {
                    priorityMacroBlockMatcher.reset();
                    rootBlock.getFirstBlock((BlockMatcher)priorityMacroBlockMatcher, Block.Axes.DESCENDANT);
                    this.processErrors(priorityMacroBlockMatcher);
                }
                if ((macroItem = priorityMacroBlockMatcher.getNextBlock()) == null) {
                    return;
                }
                macroBlock = macroItem.block();
                macro = macroItem.macro();
                incrementRecursions = macroBlock.getParent() instanceof MacroMarkerBlock;
                if (!macroBlock.isInline()) break block16;
                macroContext.setInline(true);
                if (macro.supportsInlineMode()) ** GOTO lbl26
                this.macroErrorManager.generateError(macroBlock, "rendering.macro.error.standalone", "The [{}] macro is a standalone macro and it cannot be used inline", "This macro generates standalone content. As a consequence you need to make sure to use a syntax that separates your macro from the content before and after it so that it's on a line by itself. For example in XWiki Syntax 2.0+ this means having 2 newline characters (a.k.a line breaks) separating your macro from the content before and after it.", new Object[]{macroBlock.getId()});
                ((MutableRenderingContext)this.renderingContext).setCurrentBlock(null);
                continue;
            }
            macroContext.setInline(false);
lbl26:
            // 2 sources

            macroContext.setCurrentMacroBlock(macroBlock);
            ((MutableRenderingContext)this.renderingContext).setCurrentBlock((Block)macroBlock);
            macroParameters = macro.getDescriptor().getParametersBeanClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                this.beanManager.populate(macroParameters, macroBlock.getParameters());
            }
            catch (Throwable e) {
                this.macroErrorManager.generateError(macroBlock, "rendering.macro.error.invalidParameter", "Invalid macro parameters used for the [{}] macro.", null, new Object[]{macroBlock.getId(), e});
                ((MutableRenderingContext)this.renderingContext).setCurrentBlock(null);
                continue;
            }
            try {
                if (macroItem.index().length >= 64 || !this.isolatedExecutionConfiguration.isExecutionIsolated(macroBlock.getId(), macro.isExecutionIsolated(macroParameters, macroBlock.getContent()))) {
                    priorityMacroBlockMatcher.reset();
                }
                newBlocks = macro.execute(macroParameters, macroBlock.getContent(), macroContext);
            }
            catch (Throwable e) {
                if (macroBlock.getParent() == null) {
                    this.logger.warn("The macro [{}] failed to execute and removed itself from the document so no error can be displayed. The root cause of the error is: [{}]", (Object)macroBlock.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    continue;
                }
                this.macroErrorManager.generateError(macroBlock, "rendering.macro.error.failed", "Failed to execute the [{}] macro.", null, new Object[]{macroBlock.getId(), e});
                continue;
            }
            catch (Throwable var13_15) {
                throw var13_15;
            }
            finally {
                ((MutableRenderingContext)this.renderingContext).setCurrentBlock(null);
                continue;
            }
            if (macroBlock.getParent() != null) {
                resultBlock = this.wrapInMacroMarker(macroBlock, newBlocks);
                if (!priorityMacroBlockMatcher.isFullScanNeeded()) {
                    childrenMatcher = priorityMacroBlockMatcher.getChildrenMatcher(macroItem);
                    resultBlock.getFirstBlock(childrenMatcher, Block.Axes.DESCENDANT);
                    this.processErrors(priorityMacroBlockMatcher);
                }
                macroBlock.getParent().replaceChild(resultBlock, (Block)macroBlock);
            }
            if (!incrementRecursions) continue;
            ++recursions;
        }
    }

    private void processErrors(PriorityMacroBlockMatcher priorityMacroBlockMatcher) {
        if (priorityMacroBlockMatcher.getErrors() != null) {
            for (MacroLookupExceptionElement error : priorityMacroBlockMatcher.getErrors()) {
                if (error.getException() instanceof MacroNotFoundException) {
                    this.macroErrorManager.generateError(error.getMacroBlock(), TM_UNKNOWNMACRO, "Unknown macro: {}.", "The [{}] macro is not in the list of registered macros. Verify the spelling or contact your administrator.", error.getMacroBlock().getId());
                    continue;
                }
                this.macroErrorManager.generateError(error.getMacroBlock(), TM_INVALIDMACRO, "Invalid macro: {}.", null, error.getMacroBlock().getId(), error.getException());
            }
            priorityMacroBlockMatcher.getErrors().clear();
        }
    }

    private Block wrapInMacroMarker(MacroBlock macroBlockToWrap, List<Block> newBlocks) {
        return new MacroMarkerBlock(macroBlockToWrap.getId(), macroBlockToWrap.getParameters(), macroBlockToWrap.getContent(), newBlocks, macroBlockToWrap.isInline());
    }

    public void setMaxRecursions(int maxRecursions) {
        this.maxRecursions = maxRecursions;
    }

    public void prepare(Block block) {
        Syntax syntax = block.getSyntaxMetadata().orElse(null);
        try {
            this.prepare(block, syntax);
        }
        catch (StackOverflowError e) {
            this.logger.error("Failed to prepare the block", (Throwable)e);
        }
    }

    private void prepare(Block block, Syntax parentSyntax) {
        Syntax blockSyntax;
        Syntax currentSyntax = parentSyntax;
        if (block instanceof MetaDataBlock && (blockSyntax = (Syntax)((MetaDataBlock)block).getMetaData().getMetaData("syntax")) != null) {
            currentSyntax = blockSyntax;
        }
        if (block instanceof MacroBlock) {
            MacroBlock macroBlock = (MacroBlock)block;
            Macro<?> macro = null;
            try {
                macro = this.macroManager.getMacro(new MacroId(macroBlock.getId(), currentSyntax));
            }
            catch (Exception e) {
                this.logger.debug("Failed to get the macro with identifier [{}] for syntax [{}] (this macro block won't be prepared): {}", new Object[]{macroBlock.getId(), currentSyntax, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
            if (macro != null) {
                try {
                    macro.prepare(macroBlock);
                }
                catch (Exception e) {
                    this.logger.error("Failed to prepare the macro block", (Throwable)e);
                }
            }
        }
        for (Block child : block.getChildren()) {
            this.prepare(child, currentSyntax);
        }
    }

    private class PriorityMacroBlockMatcher
    implements BlockMatcher {
        private final Syntax syntax;
        private boolean needsScan = true;
        private int currentIndex;
        private PriorityQueue<MacroItem> priorityQueue;
        private final List<MacroItem> nextBlocks;
        private List<MacroLookupExceptionElement> errors;
        private final Map<String, Macro<?>> knownMacros = new HashMap();

        PriorityMacroBlockMatcher(Syntax syntax) {
            this.syntax = syntax;
            this.nextBlocks = new ArrayList<MacroItem>();
        }

        public MacroItem getNextBlock() {
            if (this.priorityQueue == null) {
                if (this.nextBlocks.isEmpty()) {
                    return null;
                }
                this.priorityQueue = new PriorityQueue<MacroItem>(this.nextBlocks);
                this.nextBlocks.clear();
            }
            MacroItem item = this.priorityQueue.poll();
            if (this.priorityQueue.isEmpty()) {
                this.priorityQueue = null;
            }
            return item;
        }

        public boolean isFullScanNeeded() {
            return this.needsScan;
        }

        public List<MacroLookupExceptionElement> getErrors() {
            return this.errors;
        }

        public BlockMatcher getChildrenMatcher(MacroItem parentMacro) {
            return new ChildrenMatcher(parentMacro);
        }

        public void reset() {
            this.needsScan = true;
            this.currentIndex = 0;
            this.priorityQueue = null;
            this.nextBlocks.clear();
            this.errors = null;
        }

        public boolean match(Block block) {
            this.matchBlock(block, new int[0]);
            return false;
        }

        private void matchBlock(Block block, int[] prefix) {
            this.needsScan = false;
            if (block instanceof MacroBlock) {
                MacroBlock macroBlock = (MacroBlock)block;
                try {
                    Macro<?> macro = this.knownMacros.get(macroBlock.getId());
                    if (macro == null) {
                        macro = MacroTransformation.this.macroManager.getMacro(new MacroId(macroBlock.getId(), this.syntax));
                        this.knownMacros.put(macroBlock.getId(), macro);
                    }
                    int[] macroIndex = new int[prefix.length + 1];
                    System.arraycopy(prefix, 0, macroIndex, 0, prefix.length);
                    macroIndex[prefix.length] = this.currentIndex++;
                    MacroItem item = new MacroItem(macroBlock, macro, macroIndex);
                    if (this.priorityQueue == null) {
                        this.nextBlocks.add(item);
                    } else {
                        this.priorityQueue.add(item);
                    }
                }
                catch (MacroLookupException e) {
                    if (this.errors == null) {
                        this.errors = new ArrayList<MacroLookupExceptionElement>();
                    }
                    this.errors.add(new MacroLookupExceptionElement(macroBlock, e));
                }
            }
        }

        private class ChildrenMatcher
        implements BlockMatcher {
            private final int[] prefix;

            ChildrenMatcher(MacroItem parentMacro) {
                this.prefix = parentMacro.index();
            }

            public boolean match(Block block) {
                PriorityMacroBlockMatcher.this.matchBlock(block, this.prefix);
                return false;
            }
        }
    }

    private record MacroItem(MacroBlock block, Macro<?> macro, int[] index) implements Comparable<MacroItem>
    {
        @Override
        public int compareTo(MacroItem macroItem) {
            int macroComparison = this.macro.compareTo(macroItem.macro);
            if (macroComparison == 0) {
                return Arrays.compare(this.index, macroItem.index);
            }
            return macroComparison;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MacroItem)) {
                return false;
            }
            MacroItem macroItem = (MacroItem)object;
            return new EqualsBuilder().append(this.index(), macroItem.index()).append(this.macro(), macroItem.macro()).append((Object)this.block(), (Object)macroItem.block()).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.block()).append(this.macro()).append(this.index()).toHashCode();
        }

        @Override
        public String toString() {
            return new XWikiToStringBuilder((Object)this).append("block", (Object)this.block()).append("macro", this.macro()).append("index", this.index()).toString();
        }
    }

    private static class MacroLookupExceptionElement {
        private MacroBlock macroBlock;
        private MacroLookupException exception;

        public MacroLookupExceptionElement(MacroBlock macroBlock, MacroLookupException exception) {
            this.macroBlock = macroBlock;
            this.exception = exception;
        }

        public MacroBlock getMacroBlock() {
            return this.macroBlock;
        }

        public MacroLookupException getException() {
            return this.exception;
        }
    }
}

