/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.util.ParserUtils;

@Component
@Singleton
public class DefaultMacroContentParser
implements MacroContentParser {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    @Named(value="macro")
    private Transformation transformation;
    private ParserUtils parserUtils = new ParserUtils();

    @Override
    public XDOM parse(String content, MacroTransformationContext macroContext, boolean transform, boolean inline) throws MacroExecutionException {
        return this.parse(content, macroContext, transform, null, inline);
    }

    @Override
    public XDOM parse(String content, MacroTransformationContext macroContext, boolean transform, MetaData metadata, boolean inline) throws MacroExecutionException {
        return this.parse(content, null, macroContext, transform, metadata, inline);
    }

    @Override
    public XDOM parse(String content, Syntax syntax, MacroTransformationContext macroContext, boolean transform, MetaData metadata, boolean inline) throws MacroExecutionException {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return new XDOM(Collections.emptyList(), metadata != null ? metadata : MetaData.EMPTY);
        }
        Syntax finalSyntax = syntax;
        if (finalSyntax == null) {
            finalSyntax = this.getCurrentSyntax(macroContext);
        }
        if (finalSyntax == null) {
            throw new MacroExecutionException("Invalid Transformation: missing Syntax");
        }
        return this.createXDOM(content, macroContext, transform, metadata, inline, finalSyntax);
    }

    private XDOM getPreparedXDOM(String content, MacroTransformationContext macroContext, Syntax syntax) {
        Syntax preparedSyntax;
        XDOM preparedXDOM;
        if (macroContext.getCurrentMacroBlock() != null && macroContext.getCurrentMacroBlock().getContent() == content && (preparedXDOM = (XDOM)macroContext.getCurrentMacroBlock().getAttribute("prepare.content.xdom")) != null && syntax.equals((Object)(preparedSyntax = (Syntax)preparedXDOM.getMetaData().getMetaData("syntax")))) {
            return preparedXDOM;
        }
        return null;
    }

    private XDOM createXDOM(String content, MacroTransformationContext macroContext, boolean transform, MetaData metadata, boolean inline, Syntax syntax) throws MacroExecutionException {
        XDOM result = this.getPreparedXDOM(content, macroContext, syntax);
        if (result == null) {
            IdGenerator idGenerator = null;
            idGenerator = macroContext.getXDOM() != null ? macroContext.getXDOM().getIdGenerator() : null;
            result = this.parse(content, syntax, inline, idGenerator);
        } else {
            result = result.clone();
            Boolean preparedInline = (Boolean)macroContext.getCurrentMacroBlock().getAttribute("prepare.content.xdom.inline");
            if (inline && BooleanUtils.isNotTrue((Boolean)preparedInline)) {
                result = this.convertToInline(result);
            }
        }
        if (metadata != null) {
            result.getMetaData().addMetaData(metadata);
        }
        if (transform && macroContext.getTransformation() != null) {
            try {
                TransformationContext wrappingContext = macroContext.getTransformationContext();
                boolean isRestricted = wrappingContext != null && wrappingContext.isRestricted();
                TransformationContext txContext = new TransformationContext(result, syntax, isRestricted);
                txContext.setId(macroContext.getId());
                this.performTransformation((MutableRenderingContext)this.renderingContext, macroContext.getTransformation(), txContext, (Block)result);
            }
            catch (Exception e) {
                throw new MacroExecutionException("Failed to tranform the content [" + content + "]", e);
            }
        }
        return result;
    }

    private XDOM parse(String content, Syntax syntax, boolean inline, IdGenerator idGenerator) throws MacroExecutionException {
        try {
            Parser parser = this.getSyntaxParser(syntax);
            XDOM result = idGenerator != null ? parser.parse((Reader)new StringReader(content), idGenerator) : parser.parse((Reader)new StringReader(content));
            if (inline) {
                result = this.convertToInline(result);
            }
            return result;
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "]", e);
        }
    }

    private void performTransformation(MutableRenderingContext renderingContext, Transformation transformation, TransformationContext context, Block block) throws MacroExecutionException {
        try {
            renderingContext.transformInContext(transformation, context, block);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to perform transformation", e);
        }
    }

    private XDOM convertToInline(XDOM xdom) {
        if (!xdom.getChildren().isEmpty()) {
            return (XDOM)this.parserUtils.convertToInline((Block)xdom, true);
        }
        return xdom;
    }

    @Override
    public void prepareContentWiki(MacroBlock macroBlock, Syntax syntax) throws MacroPreparationException {
        if (macroBlock.getContent() != null) {
            Syntax contentSyntax = syntax;
            if (contentSyntax == null) {
                Optional syntaxMetadata = macroBlock.getSyntaxMetadata();
                contentSyntax = (Syntax)syntaxMetadata.orElseThrow(() -> new MacroPreparationException("No syntax provided to parse the content"));
            }
            Optional idGenerator = macroBlock.get(b -> b instanceof XDOM ? Optional.ofNullable(((XDOM)b).getIdGenerator()) : Optional.empty(), Block.Axes.DESCENDANT_OR_SELF);
            try {
                XDOM result = this.parse(macroBlock.getContent(), contentSyntax, macroBlock.isInline(), idGenerator.isPresent() ? (IdGenerator)idGenerator.get() : null);
                this.transformation.prepare((Block)result);
                macroBlock.setAttribute("prepare.content.xdom", (Object)result);
                macroBlock.setAttribute("prepare.content.xdom.inline", (Object)macroBlock.isInline());
            }
            catch (MacroExecutionException e) {
                throw new MacroPreparationException("Failed to parse the content", e);
            }
        }
    }

    private Parser getSyntaxParser(Syntax syntax) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.getInstance(Parser.class, syntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser for syntax [" + String.valueOf(syntax) + "]", e);
        }
    }

    @Override
    public Syntax getCurrentSyntax(MacroTransformationContext context) {
        Syntax currentSyntax = context.getSyntax();
        MacroBlock currentMacroBlock = context.getCurrentMacroBlock();
        if (currentMacroBlock != null) {
            return currentMacroBlock.getSyntaxMetadata().orElse(currentSyntax);
        }
        return currentSyntax;
    }
}

