/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroCategoryManager;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.macro.MacroTransformationConfiguration;

@Component
@Singleton
public class DefaultMacroCategoryManager
implements MacroCategoryManager {
    @Inject
    private MacroTransformationConfiguration configuration;
    @Inject
    private MacroManager macroManager;
    @Inject
    private ConverterManager converterManager;
    @Inject
    private Logger logger;

    @Override
    public Set<String> getMacroCategories() throws MacroLookupException {
        return this.getMacroCategories((Syntax)null);
    }

    @Override
    public Set<String> getMacroCategories(Syntax syntax) throws MacroLookupException {
        return Collections.unmodifiableSet(this.getMacrosGroupedByCategories(syntax).keySet());
    }

    @Override
    public Set<MacroId> getMacroIds(String category) throws MacroLookupException {
        return this.getMacroIds(category, null);
    }

    @Override
    public Set<MacroId> getMacroIds(String category, Syntax syntax) throws MacroLookupException {
        Set<MacroId> macros = this.getMacrosGroupedByCategories(syntax).get(category);
        return null != macros ? Collections.unmodifiableSet(macros) : Collections.emptySet();
    }

    @Override
    public Set<String> getMacroCategories(MacroId macroId) {
        Set<String> categories;
        Properties properties = this.configuration.getCategories();
        if (properties == null || !properties.containsKey(macroId.getId())) {
            try {
                Macro<?> macro = this.macroManager.getMacro(macroId);
                categories = macro.getDescriptor().getDefaultCategories();
            }
            catch (MacroLookupException e) {
                this.logger.warn("Failed to get macro [{}]. Cause: [{}]", (Object)macroId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                categories = Set.of();
            }
        } else {
            categories = this.splitCategories((String)properties.get(macroId.getId()));
        }
        return categories;
    }

    @Override
    public Set<String> getHiddenCategories() {
        return this.configuration.getHiddenCategories();
    }

    private Map<String, Set<MacroId>> getMacroIdsByCategory(MacroMatcher matcher) throws MacroLookupException {
        HashMap<String, Set<MacroId>> result = new HashMap<String, Set<MacroId>>();
        Set<MacroId> macroIds = this.macroManager.getMacroIds();
        Properties categories = this.configuration.getCategories();
        for (MacroId macroId : macroIds) {
            if (!matcher.match(macroId)) continue;
            String macroCategoriesProperty = categories.getProperty(macroId.getId());
            Set<String> macroCategories = macroCategoriesProperty == null ? this.macroManager.getMacro(macroId).getDescriptor().getDefaultCategories() : this.splitCategories(macroCategoriesProperty);
            if (macroCategories != null) {
                for (String macroCategory : macroCategories) {
                    this.addToCategory(result, macroId, macroCategory);
                }
                continue;
            }
            this.addToCategory(result, macroId, null);
        }
        return result;
    }

    private Map<String, Set<MacroId>> getMacrosGroupedByCategories(Syntax syntax) throws MacroLookupException {
        return this.getMacroIdsByCategory(macroId -> syntax == null || macroId.getSyntax() == null || macroId.getSyntax().equals((Object)syntax));
    }

    private void addToCategory(Map<String, Set<MacroId>> result, MacroId macroId, String macroCategory) {
        Set<MacroId> ids = result.get(macroCategory);
        if (ids == null) {
            ids = new HashSet<MacroId>();
        }
        ids.add(macroId);
        result.put(macroCategory, ids);
    }

    private Set<String> splitCategories(String categories) {
        return new HashSet<String>((Collection)this.converterManager.getConverter(List.class).convert(List.class, (Object)categories));
    }

    private static interface MacroMatcher {
        public boolean match(MacroId var1);
    }
}

