/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block.match;

import java.util.Optional;
import java.util.function.Function;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.match.BlockMatcher;

public class FunctionBlockMatcher<T>
implements BlockMatcher {
    private final Function<Block, Optional<T>> function;
    private Optional<T> value = Optional.empty();

    public FunctionBlockMatcher(Function<Block, Optional<T>> function) {
        this.function = function;
    }

    @Override
    public boolean match(Block block) {
        Optional<T> result = this.function.apply(block);
        if (result.isEmpty()) {
            return false;
        }
        this.value = result;
        return true;
    }

    public Optional<T> getValue() {
        return this.value;
    }
}

