/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xar.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.LocaleUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.DefaultSymbolScheme;
import org.xwiki.model.internal.reference.RelativeStringEntityReferenceResolver;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.xar.XarException;
import org.xwiki.xml.stax.StAXUtils;

public final class XarUtils {
    public static final RelativeStringEntityReferenceResolver RESOLVER = new RelativeStringEntityReferenceResolver((SymbolScheme)new DefaultSymbolScheme());
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    private XarUtils() {
    }

    public static LocalDocumentReference getReference(File documentFile) throws XarException {
        LocalDocumentReference localDocumentReference;
        FileInputStream stream = new FileInputStream(documentFile);
        try {
            localDocumentReference = XarUtils.getReference(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new XarException("Cannot find file", e);
            }
            catch (IOException e) {
                throw new XarException("Failed close file stream", e);
            }
        }
        stream.close();
        return localDocumentReference;
    }

    public static LocalDocumentReference getReference(InputStream documentStream) throws XarException {
        String legacyPage;
        String legacySpace;
        Locale locale;
        EntityReference reference;
        block34: {
            XMLStreamReader xmlReader;
            try {
                xmlReader = XML_INPUT_FACTORY.createXMLStreamReader(documentStream);
            }
            catch (XMLStreamException e) {
                throw new XarException("Failed to create a XML read", e);
            }
            reference = null;
            locale = null;
            legacySpace = null;
            legacyPage = null;
            try {
                String localeString;
                xmlReader.nextTag();
                xmlReader.require(1, null, "xwikidoc");
                String referenceString = xmlReader.getAttributeValue(null, "reference");
                if (referenceString != null) {
                    reference = RESOLVER.resolve(referenceString, EntityType.DOCUMENT, new Object[0]);
                }
                if ((localeString = xmlReader.getAttributeValue(null, "locale")) != null) {
                    locale = localeString.isEmpty() ? Locale.ROOT : LocaleUtils.toLocale((String)localeString);
                }
                if (reference != null && locale != null) break block34;
                xmlReader.nextTag();
                while (xmlReader.isStartElement()) {
                    String elementName = xmlReader.getLocalName();
                    if ("name".equals(elementName)) {
                        if (reference == null) {
                            legacyPage = xmlReader.getElementText();
                            if (legacySpace != null && locale != null) {
                                break;
                            }
                        } else if (locale != null) {
                            break;
                        }
                    } else if ("web".equals(elementName)) {
                        if (reference == null) {
                            legacySpace = xmlReader.getElementText();
                            if (legacyPage != null && locale != null) {
                                break;
                            }
                        } else if (locale != null) {
                            break;
                        }
                    } else if ("language".equals(elementName)) {
                        if (locale == null) {
                            String value = xmlReader.getElementText();
                            locale = value.length() == 0 ? Locale.ROOT : LocaleUtils.toLocale((String)value);
                        }
                        if (reference != null) break;
                        if (legacySpace != null && legacyPage != null) {
                            break;
                        }
                    } else {
                        StAXUtils.skipElement((XMLStreamReader)xmlReader);
                    }
                    xmlReader.nextTag();
                }
            }
            catch (XMLStreamException e) {
                throw new XarException("Failed to parse document", e);
            }
            finally {
                try {
                    xmlReader.close();
                }
                catch (XMLStreamException e) {
                    throw new XarException("Failed to close XML reader", e);
                }
            }
        }
        if (reference == null) {
            if (legacySpace == null) {
                throw new XarException("Missing space element");
            }
            if (legacyPage == null) {
                throw new XarException("Missing page element");
            }
            reference = new LocalDocumentReference(legacySpace, legacyPage);
        }
        if (locale == null) {
            throw new XarException("Missing locale element");
        }
        return new LocalDocumentReference(reference, locale);
    }
}

