/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.importer;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.officeimporter.OfficeImporterException;
import org.xwiki.officeimporter.builder.PresentationBuilder;
import org.xwiki.officeimporter.builder.XDOMOfficeDocumentBuilder;
import org.xwiki.officeimporter.document.OfficeDocumentArtifact;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.store.TemporaryAttachmentSessionsManager;
import org.xwiki.wysiwyg.importer.AttachmentImporter;
import org.xwiki.wysiwyg.internal.importer.OfficeMacroImporter;

@Component
@Singleton
@Named(value="office")
public class OfficeAttachmentImporter
implements AttachmentImporter {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private PresentationBuilder presentationBuilder;
    @Inject
    private XDOMOfficeDocumentBuilder documentBuilder;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private OfficeMacroImporter officeMacroImporter;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private TemporaryAttachmentSessionsManager temporaryAttachmentSessionsManager;
    @Inject
    private Provider<XWikiContext> contextProvider;

    @Override
    public String toHTML(AttachmentReference attachmentReference, Map<String, Object> parameters) throws Exception {
        boolean filterStyles = Boolean.valueOf(String.valueOf(parameters.get("filterStyles")));
        if (Boolean.valueOf(String.valueOf(parameters.get("useOfficeViewer"))).booleanValue()) {
            return this.officeMacroImporter.render(this.officeMacroImporter.buildXDOM(attachmentReference, filterStyles));
        }
        return this.maybeConvertAttachmentContent(attachmentReference, filterStyles);
    }

    private String maybeConvertAttachmentContent(AttachmentReference attachmentReference, boolean filterStyles) throws Exception {
        if (this.authorization.hasAccess(Right.EDIT, (EntityReference)attachmentReference)) {
            if (this.documentAccessBridge.getAttachmentVersion(attachmentReference) != null || this.temporaryAttachmentSessionsManager.getUploadedAttachment(attachmentReference).isPresent()) {
                if (this.officeServer.getState() == OfficeServer.ServerState.CONNECTED) {
                    return this.convertAttachmentContent(attachmentReference, filterStyles);
                }
                throw new RuntimeException("The office server is not connected.");
            }
            throw new RuntimeException(String.format("Attachment not found: [%s].", this.entityReferenceSerializer.serialize((EntityReference)attachmentReference, new Object[0])));
        }
        throw new RuntimeException(String.format("Edit right is required in order to import [%s].", this.entityReferenceSerializer.serialize((EntityReference)attachmentReference, new Object[0])));
    }

    private String convertAttachmentContent(AttachmentReference attachmentReference, boolean filterStyles) throws Exception {
        InputStream officeFileStream;
        if (this.documentAccessBridge.getAttachmentVersion(attachmentReference) != null) {
            officeFileStream = this.documentAccessBridge.getAttachmentContent(attachmentReference);
        } else {
            Optional uploadedAttachment = this.temporaryAttachmentSessionsManager.getUploadedAttachment(attachmentReference);
            if (uploadedAttachment.isPresent()) {
                officeFileStream = ((XWikiAttachment)uploadedAttachment.get()).getContentInputStream((XWikiContext)this.contextProvider.get());
            } else {
                throw new OfficeImporterException(String.format("Cannot find temporary uplodaded attachment [%s]", attachmentReference));
            }
        }
        String officeFileName = attachmentReference.getName();
        DocumentReference targetDocRef = attachmentReference.getDocumentReference();
        XDOMOfficeDocument xdomOfficeDocument = this.isPresentation(attachmentReference.getName()) ? this.presentationBuilder.build(officeFileStream, officeFileName, targetDocRef) : this.documentBuilder.build(officeFileStream, officeFileName, targetDocRef, filterStyles);
        for (Map.Entry entry : xdomOfficeDocument.getArtifactsMap().entrySet()) {
            String filename = (String)entry.getKey();
            OfficeDocumentArtifact artifact = (OfficeDocumentArtifact)entry.getValue();
            AttachmentReference artifactReference = new AttachmentReference(filename, targetDocRef);
            InputStream is = artifact.getContentInputStream();
            try {
                this.documentAccessBridge.setAttachmentContent(artifactReference, is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        String result = xdomOfficeDocument.getContentAsString("annotatedxhtml/1.0");
        xdomOfficeDocument.close();
        return result;
    }

    private boolean isPresentation(String fileName) {
        if (this.officeServer.getConverter() != null) {
            return this.officeServer.getConverter().isPresentation(fileName);
        }
        return false;
    }
}

