/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.converter;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.wysiwyg.converter.HTMLConverter;
import org.xwiki.wysiwyg.converter.JakartaRequestParameterConversionResult;
import org.xwiki.wysiwyg.filter.MutableJakartaServletRequest;
import org.xwiki.wysiwyg.internal.converter.AbstractRequestParameterConverter;

@Component
@Singleton
@Named(value="html")
public class HTMLRequestParameterConverter
extends AbstractRequestParameterConverter {
    @Inject
    private HTMLConverter htmlConverter;

    @Override
    protected String getConverterParameterName() {
        return "RequiresHTMLConversion";
    }

    @Override
    protected void convert(String[] parametersRequiringConversion, JakartaRequestParameterConversionResult conversionResult) {
        MutableJakartaServletRequest request = conversionResult.getRequest();
        for (String parameterName : parametersRequiringConversion) {
            String html = request.getParameter(parameterName);
            String syntax = request.removeParameter(parameterName + "_syntax");
            if (html == null || syntax == null) continue;
            try {
                request.setParameter(parameterName, this.htmlConverter.fromHTML(html, syntax));
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
                conversionResult.getErrors().put(parameterName, e);
            }
            conversionResult.getOutput().put(parameterName, request.getParameter(parameterName));
        }
    }
}

