/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.converter;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletRequest;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Optional;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.wysiwyg.converter.JakartaRequestParameterConversionResult;
import org.xwiki.wysiwyg.converter.RequestParameterConverter;
import org.xwiki.wysiwyg.filter.MutableJakartaServletRequest;
import org.xwiki.wysiwyg.internal.converter.AbstractRequestParameterConverter;

@Component
@Singleton
public class DefaultRequestParameterConverter
extends AbstractRequestParameterConverter {
    @Inject
    private SyntaxRegistry syntaxRegistry;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;

    @Override
    protected String getConverterParameterName() {
        return "RequiresConversion";
    }

    @Override
    public JakartaRequestParameterConversionResult convert(ServletRequest request) {
        JakartaRequestParameterConversionResult result = super.convert(request);
        try {
            for (Map.Entry entry : this.contextComponentManager.getInstanceMap(RequestParameterConverter.class).entrySet()) {
                if ("default".equals(entry.getKey())) continue;
                RequestParameterConverter converter = (RequestParameterConverter)entry.getValue();
                JakartaRequestParameterConversionResult intermediateResult = converter.convert(result.getRequest());
                result.getErrors().putAll(intermediateResult.getErrors());
                result.getOutput().putAll(intermediateResult.getOutput());
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error while getting RequestParameterConverter", (Throwable)e);
        }
        return result;
    }

    @Override
    protected void convert(String[] parametersRequiringConversion, JakartaRequestParameterConversionResult conversionResult) {
        MutableJakartaServletRequest request = conversionResult.getRequest();
        for (String parameterName : parametersRequiringConversion) {
            String content = request.getParameter(parameterName);
            Optional inputSyntax = this.syntaxRegistry.getSyntax(request.removeParameter(parameterName + "_inputSyntax"));
            Optional outputSyntax = this.syntaxRegistry.getSyntax(request.removeParameter(parameterName + "_outputSyntax"));
            if (content == null || !inputSyntax.isPresent() || !outputSyntax.isPresent()) continue;
            try {
                request.setParameter(parameterName, this.convert(content, (Syntax)inputSyntax.get(), (Syntax)outputSyntax.get()));
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
                conversionResult.getErrors().put(parameterName, e);
            }
            conversionResult.getOutput().put(parameterName, request.getParameter(parameterName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convert(String content, Syntax inputSyntax, Syntax outputSyntax) throws ComponentLookupException, ParseException {
        boolean renderingContextPushed = false;
        try {
            renderingContextPushed = this.maybeSetRenderingContextSyntax(outputSyntax);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            PrintRendererFactory printRendererFactory = (PrintRendererFactory)this.contextComponentManager.getInstance(PrintRendererFactory.class, outputSyntax.toIdString());
            StreamParser parser = (StreamParser)this.contextComponentManager.getInstance(StreamParser.class, inputSyntax.toIdString());
            parser.parse((Reader)new StringReader(content), (Listener)printRendererFactory.createRenderer((WikiPrinter)printer));
            String string = printer.toString();
            return string;
        }
        finally {
            if (renderingContextPushed) {
                ((MutableRenderingContext)this.renderingContext).pop();
            }
        }
    }

    private boolean maybeSetRenderingContextSyntax(Syntax syntax) {
        RenderingContext renderingContext = this.renderingContext;
        if (renderingContext instanceof MutableRenderingContext) {
            MutableRenderingContext mutableRenderingContext = (MutableRenderingContext)renderingContext;
            mutableRenderingContext.push(this.renderingContext.getTransformation(), this.renderingContext.getXDOM(), syntax, this.renderingContext.getTransformationId(), this.renderingContext.isRestricted(), syntax);
            return true;
        }
        return false;
    }
}

