/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.converter;

import java.io.Reader;
import java.io.StringReader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.wysiwyg.cleaner.HTMLCleaner;
import org.xwiki.wysiwyg.converter.HTMLConverter;

@Component
@Singleton
public class DefaultHTMLConverter
implements HTMLConverter {
    private static final String TRANSFORMATION_ID = "wysiwygtxid";
    @Inject
    private Logger logger;
    @Inject
    private HTMLCleaner htmlCleaner;
    @Inject
    @Named(value="xhtml/5")
    private Parser xhtmlParser;
    @Inject
    @Named(value="xhtml/5")
    private StreamParser xhtmlStreamParser;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private ContentParser contentParser;
    @Inject
    @Named(value="macro")
    private Transformation macroTransformation;
    @Inject
    @Named(value="annotatedhtml/5.0")
    private BlockRenderer xhtmlRenderer;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    @Override
    public String fromHTML(String dirtyHTML, String syntaxId) {
        boolean renderingContextPushed = false;
        try {
            String html = this.htmlCleaner.clean(dirtyHTML);
            renderingContextPushed = this.maybeSetRenderingContextSyntax(Syntax.valueOf((String)syntaxId));
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            PrintRendererFactory printRendererFactory = (PrintRendererFactory)this.contextComponentManager.getInstance(PrintRendererFactory.class, syntaxId);
            this.xhtmlStreamParser.parse((Reader)new StringReader(html), (Listener)printRendererFactory.createRenderer((WikiPrinter)printer));
            String string = printer.toString();
            return string;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while parsing HTML", e);
        }
        finally {
            if (renderingContextPushed) {
                ((MutableRenderingContext)this.renderingContext).pop();
            }
        }
    }

    @Override
    public String toHTML(String source, String syntaxId) {
        return this.toHTML(source, this.getSyntax(syntaxId), null);
    }

    @Override
    public String toHTML(String source, Syntax syntax, EntityReference sourceReference) {
        return this.toHTML(source, syntax, sourceReference, false);
    }

    @Override
    public String toHTML(String source, Syntax syntax, EntityReference sourceReference, boolean restricted) {
        try {
            XDOM xdom = this.contentParser.parse(source, syntax, sourceReference);
            this.executeMacroTransformation(xdom, syntax, restricted);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.xhtmlRenderer.render((Block)xdom, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while rendering HTML", e);
        }
    }

    @Override
    public String parseAndRender(String dirtyHTML, String syntaxId) {
        return this.parseAndRender(dirtyHTML, this.getSyntax(syntaxId), null);
    }

    @Override
    public String parseAndRender(String dirtyHTML, Syntax syntax, EntityReference sourceReference) {
        return this.parseAndRender(dirtyHTML, syntax, sourceReference, false);
    }

    @Override
    public String parseAndRender(String dirtyHTML, Syntax syntax, EntityReference sourceReference, boolean restricted) {
        boolean renderingContextPushed = false;
        try {
            String html = this.htmlCleaner.clean(dirtyHTML);
            renderingContextPushed = this.maybeSetRenderingContextSyntax(syntax);
            XDOM xdom = this.xhtmlParser.parse((Reader)new StringReader(html));
            if (sourceReference != null) {
                xdom.getMetaData().addMetaData("source", this.serializer.serialize(sourceReference, new Object[0]));
            }
            xdom.getMetaData().addMetaData("syntax", (Object)syntax);
            this.executeMacroTransformation(xdom, syntax, restricted);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.xhtmlRenderer.render((Block)xdom, (WikiPrinter)printer);
            String string = printer.toString();
            return string;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException("Exception while refreshing HTML", e);
        }
        finally {
            if (renderingContextPushed) {
                ((MutableRenderingContext)this.renderingContext).pop();
            }
        }
    }

    private Syntax getSyntax(String syntaxId) {
        try {
            return Syntax.valueOf((String)syntaxId);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Invalid syntax [%s]", syntaxId), e);
        }
    }

    private boolean maybeSetRenderingContextSyntax(Syntax syntax) {
        if (this.renderingContext instanceof MutableRenderingContext) {
            ((MutableRenderingContext)this.renderingContext).push(this.renderingContext.getTransformation(), this.renderingContext.getXDOM(), syntax, this.renderingContext.getTransformationId(), this.renderingContext.isRestricted(), syntax);
            return true;
        }
        return false;
    }

    private void executeMacroTransformation(XDOM xdom, Syntax syntax, boolean restricted) throws TransformationException {
        TransformationContext txContext = new TransformationContext();
        txContext.setXDOM(xdom);
        txContext.setSyntax(syntax);
        txContext.setTargetSyntax(Syntax.ANNOTATED_HTML_5_0);
        txContext.setRestricted(restricted);
        txContext.setId(TRANSFORMATION_ID);
        if (this.renderingContext instanceof MutableRenderingContext) {
            ((MutableRenderingContext)this.renderingContext).transformInContext(this.macroTransformation, txContext, (Block)xdom);
        }
    }
}

