/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.cleaner;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.wysiwyg.internal.cleaner.AbstractHTMLFilter;
import org.xwiki.wysiwyg.internal.cleaner.HTMLFilter;

@Component(roles={HTMLFilter.class})
@Named(value="nestedAnchors")
@Singleton
public class NestedAnchorsFilter
extends AbstractHTMLFilter {
    @Inject
    private Logger logger;

    public void filter(Document document, Map<String, String> parameters) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nestedAnchors = (NodeList)xpath.compile("//a//a").evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nestedAnchors.getLength(); ++i) {
                Element nestedAnchor = (Element)nestedAnchors.item(i);
                this.unwrap(nestedAnchor);
            }
        }
        catch (XPathExpressionException e) {
            this.logger.error("Exception while filtering nested anchors.", (Throwable)e);
        }
    }

    private void unwrap(Element element) {
        Document ownerDocument = element.getOwnerDocument();
        if (ownerDocument == null) {
            return;
        }
        Element parent = (Element)element.getParentNode();
        if (parent == null) {
            return;
        }
        DocumentFragment children = element.getOwnerDocument().createDocumentFragment();
        while (element.hasChildNodes()) {
            children.appendChild(element.getChildNodes().item(0));
        }
        parent.replaceChild(children, element);
    }
}

