/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.workspacesmigrator.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.wiki.workspacesmigrator.internal.SearchSuggestCustomConfigDeleter;

@Component
@Singleton
public class DefaultSearchSuggestCustomConfigDeleter
implements SearchSuggestCustomConfigDeleter {
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    public void deleteSearchSuggestCustomConfig(String wikiId) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        DocumentReference searchConfigDocRef = new DocumentReference(wikiId, "XWiki", "SearchSuggestConfig");
        DocumentReference searchConfigClass = new DocumentReference(wikiId, "XWiki", "SearchSuggestSourceClass");
        XWikiDocument searchConfigDoc = xwiki.getDocument(searchConfigDocRef, xcontext);
        List objects = searchConfigDoc.getXObjects(searchConfigClass);
        if (objects != null) {
            boolean found = false;
            for (BaseObject object : objects) {
                String url;
                String engine;
                String query;
                String name;
                if (object == null || !(name = object.getStringValue("name")).equals("platform.workspace.searchSuggestSourceWorkspaces") || !this.isSolrObject(query = object.getStringValue("query"), engine = object.getStringValue("engine"), url = object.getStringValue("url")) && !this.isLuceneObject(query, engine, url)) continue;
                searchConfigDoc.removeXObject(object);
                found = true;
            }
            if (found) {
                xwiki.saveDocument(searchConfigDoc, "Remove object previously introduced by WorkspaceManager.Install", xcontext);
            }
        }
    }

    private boolean isSolrObject(String query, String engine, String url) {
        return engine != null && engine.equals("solr") && query.equals("class:XWiki.XWikiServerClass AND propertyname:wikiprettyname AND propertyvalue__:(__INPUT__*)") && url.equals("xwiki:WorkspaceManager.WorkspacesSuggestSolrService");
    }

    private boolean isLuceneObject(String query, String engine, String url) {
        return (engine == null || engine.equals("lucene")) && query.equals("XWiki.XWikiServerClass.wikiprettyname:__INPUT__* AND object:WorkspaceManager.WorkspaceClass") && url.equals("xwiki:WorkspaceManager.WorkspacesSuggestLuceneService");
    }
}

