/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.template.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.wiki.internal.descriptor.document.WikiDescriptorDocumentHelper;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.properties.WikiPropertyGroup;
import org.xwiki.wiki.properties.WikiPropertyGroupException;
import org.xwiki.wiki.properties.WikiPropertyGroupProvider;
import org.xwiki.wiki.template.WikiTemplatePropertyGroup;
import org.xwiki.wiki.template.internal.WikiTemplateClassDocumentInitializer;

@Component
@Named(value="template")
@Singleton
public class WikiTemplatePropertyGroupProvider
implements WikiPropertyGroupProvider {
    public static final String GROUP_NAME = "template";
    private static final String ERROR_MESSAGE_NO_DESCRIPTOR_DOCUMENT = "Unable to load descriptor document for wiki [%s].";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiDescriptorDocumentHelper wikiDescriptorDocumentHelper;

    public WikiPropertyGroup get(String wikiId) throws WikiPropertyGroupException {
        WikiTemplatePropertyGroup group = new WikiTemplatePropertyGroup(GROUP_NAME);
        try {
            XWikiDocument descriptorDocument = this.wikiDescriptorDocumentHelper.getDocumentFromWikiId(wikiId);
            BaseObject object = descriptorDocument.getXObject((EntityReference)WikiTemplateClassDocumentInitializer.SERVER_CLASS);
            if (object != null) {
                group.setTemplate(object.getIntValue("iswikitemplate", 0) != 0);
            }
        }
        catch (WikiManagerException e) {
            throw new WikiPropertyGroupException(String.format(ERROR_MESSAGE_NO_DESCRIPTOR_DOCUMENT, wikiId), (Throwable)e);
        }
        return group;
    }

    public void save(WikiPropertyGroup group, String wikiId) throws WikiPropertyGroupException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        WikiTemplatePropertyGroup templateGroup = (WikiTemplatePropertyGroup)group;
        try {
            XWikiDocument descriptorDocument = this.wikiDescriptorDocumentHelper.getDocumentFromWikiId(wikiId);
            descriptorDocument = descriptorDocument.clone();
            BaseObject object = descriptorDocument.getXObject((EntityReference)WikiTemplateClassDocumentInitializer.SERVER_CLASS, true, context);
            object.setIntValue("iswikitemplate", templateGroup.isTemplate() ? 1 : 0);
            if (descriptorDocument.getCreatorReference() == null) {
                descriptorDocument.setCreatorReference(context.getUserReference());
            }
            if (descriptorDocument.getAuthorReference() == null) {
                descriptorDocument.setAuthorReference(context.getUserReference());
            }
            xwiki.saveDocument(descriptorDocument, String.format("Changed property group [%s].", GROUP_NAME), context);
        }
        catch (WikiManagerException e) {
            throw new WikiPropertyGroupException(String.format(ERROR_MESSAGE_NO_DESCRIPTOR_DOCUMENT, wikiId), (Throwable)e);
        }
        catch (XWikiException e) {
            throw new WikiPropertyGroupException("Unable to save descriptor document.", (Throwable)e);
        }
    }
}

