/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.wiki.creationjob.script;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.job.Job;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.platform.wiki.creationjob.WikiCreationException;
import org.xwiki.platform.wiki.creationjob.WikiCreationRequest;
import org.xwiki.platform.wiki.creationjob.WikiCreator;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
@Named(value="wiki.creationjob")
public class WikiCreationJobScriptServices
implements ScriptService {
    private static final String ERROR_KEY = "scriptservice.wikicreationjob.error";
    @Inject
    private WikiCreator wikiCreator;
    @Inject
    private Execution execution;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private Logger logger;

    public Job createWiki(WikiCreationRequest request) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            WikiReference mainWikiReference = new WikiReference(this.wikiDescriptorManager.getMainWikiId());
            this.authorizationManager.checkAccess(Right.CREATE_WIKI, xcontext.getUserReference(), (EntityReference)mainWikiReference);
            if (request.getExtensionId() != null && !this.isAuthorizedExtension(request.getExtensionId())) {
                throw new WikiCreationException(String.format("The extension [%s] is not authorized.", request.getExtensionId()));
            }
            return this.wikiCreator.createWiki(request);
        }
        catch (WikiCreationException e) {
            this.setLastError(e);
            this.logger.warn("Failed to create a new wiki.", (Throwable)e);
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
        }
        return null;
    }

    private boolean isAuthorizedExtension(ExtensionId extensionId) {
        ExtensionId defaultExtension = this.getDefaultWikiExtensionId();
        if (defaultExtension != null && StringUtils.isNotBlank((CharSequence)defaultExtension.getId())) {
            return defaultExtension.equals((Object)extensionId);
        }
        return true;
    }

    public ExtensionId getDefaultWikiExtensionId() {
        return this.distributionManager.getWikiUIExtensionId();
    }

    public JobStatus getJobStatus(String wikiId) {
        return this.wikiCreator.getJobStatus(wikiId);
    }

    public WikiCreationRequest newWikiCreationRequest() {
        return new WikiCreationRequest();
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ERROR_KEY);
    }

    private void setLastError(Exception e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }
}

