/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.wiki.creationjob.internal;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.InstallJob;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.platform.wiki.creationjob.WikiCreationException;

@Component(roles={ExtensionInstaller.class})
@Singleton
public class ExtensionInstaller {
    private static final String PROPERTY_USERREFERENCE = "user.reference";
    private static final DocumentReference SUPERADMIN_REFERENCE = new DocumentReference("xwiki", "XWiki", "superadmin");
    @Inject
    private ComponentManager componentManager;

    public void installExtension(String wikiId, ExtensionId extensionId) throws WikiCreationException {
        try {
            InstallRequest installRequest = new InstallRequest();
            installRequest.setId(Arrays.asList("wikicreation", "install", wikiId));
            installRequest.addExtension(extensionId);
            installRequest.addNamespace("wiki:" + wikiId);
            installRequest.setProperty(PROPERTY_USERREFERENCE, (Object)SUPERADMIN_REFERENCE);
            InstallJob job = (InstallJob)this.componentManager.getInstance(Job.class, "install");
            job.initialize((Request)installRequest);
            job.run();
        }
        catch (ComponentLookupException e) {
            throw new WikiCreationException(String.format("Failed to install the extension [%s] on the wiki [%s].", extensionId.toString(), wikiId), e);
        }
    }
}

