/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.script;

import com.xpn.xwiki.XWikiContext;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="websocket")
@Singleton
public class WebSocketScriptService
implements ScriptService {
    private static final String UTF8 = "UTF-8";
    private static final String PATH_SEPARATOR = "/";
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public String url(String pathOrRoleHint) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            StringBuilder path = new StringBuilder(PATH_SEPARATOR);
            String webAppPath = xcontext.getWiki().getWebAppPath(xcontext);
            if (!PATH_SEPARATOR.equals(webAppPath)) {
                path.append(webAppPath);
            }
            path.append("websocket").append(this.path(pathOrRoleHint));
            URL serverURL = xcontext.getURLFactory().getServerURL(xcontext);
            String scheme = "https".equals(serverURL.getProtocol()) ? "wss" : "ws";
            return new URI(scheme, null, serverURL.getHost(), serverURL.getPort(), null, null, null).toString() + path.toString();
        }
        catch (Exception e) {
            this.logger.warn("Failed to create WebSocket URL for [{}]. Root cause is [{}].", (Object)pathOrRoleHint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private String path(String pathOrRoleHint) throws UnsupportedEncodingException {
        if (pathOrRoleHint.startsWith(PATH_SEPARATOR)) {
            return pathOrRoleHint;
        }
        String currentWiki = ((XWikiContext)this.xcontextProvider.get()).getWikiId();
        return String.format("/%s/%s", URLEncoder.encode(currentWiki, UTF8), URLEncoder.encode(pathOrRoleHint, UTF8));
    }
}

