/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.server.HandshakeRequest;
import java.net.HttpCookie;
import java.net.URI;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.container.servlet.HttpServletRequestStub;

public class XWikiWebSocketRequestStub
extends HttpServletRequestStub {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiWebSocketRequestStub.class);
    private final HandshakeRequest request;
    private final URI requestURI;
    private final String queryString;
    private final Principal userPrincipal;

    public XWikiWebSocketRequestStub(HandshakeRequest request) {
        super(XWikiWebSocketRequestStub.buildFromHandshakeRequest(request));
        this.request = request;
        this.requestURI = request.getRequestURI();
        this.queryString = request.getQueryString();
        this.userPrincipal = request.getUserPrincipal();
    }

    private static HttpServletRequestStub.Builder buildFromHandshakeRequest(HandshakeRequest request) {
        Map<String, List<String>> headers = XWikiWebSocketRequestStub.getHeaders(request);
        Optional<String> cookieHeader = headers.getOrDefault("Cookie", Collections.emptyList()).stream().findFirst();
        return new HttpServletRequestStub.Builder().setRequestParameters(XWikiWebSocketRequestStub.adaptParameterMap(request.getParameterMap())).setCookies(XWikiWebSocketRequestStub.parseCookies(cookieHeader)).setHeaders(headers).setHttpSession((HttpSession)request.getHttpSession()).setRemoteAddr("");
    }

    private static Map<String, List<String>> getHeaders(HandshakeRequest request) {
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        headers.putAll(request.getHeaders());
        return headers;
    }

    private static Cookie[] parseCookies(Optional<String> cookieHeader) {
        if (cookieHeader.isEmpty()) {
            return new Cookie[0];
        }
        String[] cookieStrings = cookieHeader.get().split("\\s*;\\s*");
        return (Cookie[])Arrays.asList(cookieStrings).stream().map(HttpCookie::parse).flatMap(Collection::stream).map(cookie -> new Cookie(cookie.getName(), cookie.getValue())).toArray(Cookie[]::new);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value != null) {
            return ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant().toEpochMilli();
        }
        return -1L;
    }

    public String getMethod() {
        return "GET";
    }

    public String getRequestURI() {
        return this.requestURI.toString();
    }

    private static Map<String, String[]> adaptParameterMap(Map<String, List<String>> params) {
        LinkedHashMap<String, String[]> parameters = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            parameters.put(entry.getKey(), entry.getValue().toArray(new String[0]));
        }
        return parameters;
    }

    public String getServletPath() {
        return "";
    }

    public String getPathInfo() {
        return this.requestURI.getPath();
    }

    public String getScheme() {
        return this.requestURI.getScheme();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public boolean isUserInRole(String role) {
        try {
            return this.request.isUserInRole(role);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to determine if the currently authenticated user has the specified role. This can happen if this method is called outside the WebSocket handshake request, i.e. from a WebSocket end-point.", (Throwable)e);
            return false;
        }
    }
}

