/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal.filter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.webjars.internal.filter.WebJarsResourceFilter;

@Component
@Named(value="velocity")
@Singleton
public class VelocityWebJarsResourceFilter
implements WebJarsResourceFilter {
    @Inject
    private VelocityManager velocityManager;

    @Override
    public InputStream filter(InputStream resourceStream, String resourceName) throws ResourceReferenceHandlerException {
        try {
            StringWriter writer = new StringWriter();
            this.velocityManager.getVelocityEngine().evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, resourceName, (Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
            return new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to evaluate the Velocity code from WebJar resource [%s]", resourceName), (Throwable)e);
        }
    }
}

