/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.tika.mime.MediaType;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.classloader.internal.ClassLoaderUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.servlet.AbstractServletResourceReferenceHandler;
import org.xwiki.tika.internal.TikaUtils;
import org.xwiki.webjars.internal.WebJarsResourceReference;
import org.xwiki.webjars.internal.filter.WebJarsResourceFilter;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsResourceReferenceHandler
extends AbstractServletResourceReferenceHandler<WebJarsResourceReference> {
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars/";
    private static final String LESS_FILE_EXTENSION = ".less";
    @Inject
    private ClassLoaderManager classLoaderManager;
    @Inject
    @Named(value="less")
    private WebJarsResourceFilter lessFilter;
    @Inject
    @Named(value="velocity")
    private WebJarsResourceFilter velocityFilter;

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(WebJarsResourceReference.TYPE);
    }

    protected InputStream getResourceStream(WebJarsResourceReference resourceReference) {
        return ClassLoaderUtils.getResourceAsStream((ClassLoader)this.getClassLoader(resourceReference.getNamespace()), (String)WEBJARS_RESOURCE_PREFIX, (String)this.getResourceName(resourceReference));
    }

    protected String getResourceName(WebJarsResourceReference resourceReference) {
        return resourceReference.getResourceName();
    }

    protected boolean isResourceCacheable(WebJarsResourceReference resourceReference) {
        return !Boolean.parseBoolean(resourceReference.getParameterValue("evaluate"));
    }

    protected InputStream filterResource(WebJarsResourceReference resourceReference, InputStream resourceStream) throws ResourceReferenceHandlerException {
        String resourceName;
        InputStream stream = !this.isResourceCacheable(resourceReference) ? ((resourceName = this.getResourceName(resourceReference)).endsWith(LESS_FILE_EXTENSION) ? this.lessFilter.filter(resourceStream, resourceName) : this.velocityFilter.filter(resourceStream, resourceName)) : super.filterResource((ResourceReference)resourceReference, resourceStream);
        return stream;
    }

    protected ClassLoader getClassLoader(String namespace) {
        return this.classLoaderManager.getURLClassLoader(namespace, true);
    }

    protected String getContentType(InputStream resourceStream, WebJarsResourceReference resourceReference) throws IOException {
        String mimeType;
        if (!this.isResourceCacheable(resourceReference) && this.getResourceName(resourceReference).endsWith(LESS_FILE_EXTENSION)) {
            mimeType = "text/css";
        } else {
            mimeType = TikaUtils.detect((String)this.getResourceName(resourceReference));
            if (mimeType.equals(MediaType.OCTET_STREAM.toString())) {
                mimeType = TikaUtils.detect((InputStream)resourceStream);
            }
        }
        return mimeType;
    }
}

