/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserConfiguration;
import org.xwiki.user.UserException;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Named(value="user")
@Singleton
public class UserScriptService
implements ScriptService {
    public static final String ROLEHINT = "user";
    @Inject
    @Named(value="secure")
    private UserPropertiesResolver userPropertiesResolver;
    @Inject
    @Named(value="secure/all")
    private UserPropertiesResolver allUserPropertiesResolver;
    @Inject
    private ScriptServiceManager scriptServiceManager;
    @Inject
    private UserManager userManager;
    @Inject
    private UserReferenceResolver<String> userReferenceResolver;
    @Inject
    private UserReferenceSerializer<String> userReferenceSerializer;
    @Inject
    private UserConfiguration userConfiguration;

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("user." + serviceName);
    }

    public UserProperties getProperties(UserReference userReference, Object ... parameters) {
        return this.userPropertiesResolver.resolve(userReference, parameters);
    }

    public UserProperties getProperties(String userReference, Object ... parameters) {
        return this.userPropertiesResolver.resolve(this.userReferenceResolver.resolve((Object)userReference, new Object[0]), parameters);
    }

    public UserProperties getProperties(Object ... parameters) {
        return this.userPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, parameters);
    }

    public UserProperties getProperties() {
        return this.userPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, new Object[0]);
    }

    public UserProperties getAllProperties(UserReference userReference, Object ... parameters) {
        return this.allUserPropertiesResolver.resolve(userReference, parameters);
    }

    public UserProperties getAllProperties(Object ... parameters) {
        return this.allUserPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, parameters);
    }

    public UserProperties getAllProperties() {
        return this.allUserPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, new Object[0]);
    }

    public UserReference getGuestUserReference() {
        return GuestUserReference.INSTANCE;
    }

    public UserReference getSuperAdminUserReference() {
        return SuperAdminUserReference.INSTANCE;
    }

    public UserReference getCurrentUserReference() {
        return CurrentUserReference.INSTANCE;
    }

    public boolean exists(UserReference userReference) throws UserException {
        return this.userManager.exists(userReference);
    }

    public String serialize(UserReference userReference) {
        return (String)this.userReferenceSerializer.serialize(userReference);
    }

    public UserConfiguration getConfiguration() {
        return this.userConfiguration;
    }
}

