/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.group;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyUpdatedEvent;
import com.xpn.xwiki.objects.BaseObjectReference;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.user.internal.group.UsersCache;

@Component
@Named(value="org.xwiki.user.internal.group.UserCacheInvalidationListener")
@Singleton
@Priority(value=100)
public class UsersCacheInvalidationListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.user.internal.group.UserCacheInvalidationListener";
    private static final String USERS_CLASSNAME = "XWiki.XWikiUsers";
    @Inject
    private UsersCache userCache;

    public UsersCacheInvalidationListener() {
        super(NAME, new Event[]{new WikiDeletedEvent(), new XObjectDeletedEvent((EntityReference)BaseObjectReference.any((String)USERS_CLASSNAME)), new XObjectAddedEvent((EntityReference)BaseObjectReference.any((String)USERS_CLASSNAME)), new XObjectPropertyUpdatedEvent(new EntityReference("active", EntityType.OBJECT_PROPERTY, (EntityReference)BaseObjectReference.any((String)USERS_CLASSNAME)))});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            WikiReference wikiReference = new WikiReference(((WikiDeletedEvent)event).getWikiId());
            this.userCache.cleanCache(wikiReference.getName());
        } else {
            XWikiDocument document = (XWikiDocument)source;
            this.userCache.cleanCache(document.getDocumentReference().getWikiReference().getName());
        }
    }
}

