/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component(roles={UsersCache.class})
@Singleton
public class UsersCache
implements Initializable,
Disposable {
    private static final int DEFAULT_CAPACITY = 50;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private QueryManager queries;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private EntityReferenceFactory referenceFactory;
    @Inject
    private Logger logger;
    private Cache<List<DocumentReference>> cache;

    public void initialize() throws InitializationException {
        LRUCacheConfiguration cacheConfig = new LRUCacheConfiguration("user.users", 50);
        try {
            this.cache = this.cacheManager.createNewCache((CacheConfiguration)cacheConfig);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to create the user cache", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.cache != null) {
            this.cache.dispose();
        }
    }

    public List<DocumentReference> getUsers(WikiReference wiki, boolean activeOnly) {
        List<Object> users;
        List result;
        String cacheKey = activeOnly + wiki.getName();
        List cached = (List)this.cache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        try {
            StringBuilder statement = new StringBuilder("select distinct doc.fullName from Document doc, doc.object(XWiki.XWikiUsers) as user");
            if (activeOnly) {
                statement.append(" where user.active = 1");
            }
            Query query = this.queries.createQuery(statement.toString(), "xwql");
            query.setWiki(wiki.getName());
            result = query.execute();
        }
        catch (QueryException e2) {
            this.logger.error("Failed to get users from the wiki [{}]", (Object)wiki, (Object)e2);
            return Collections.emptyList();
        }
        if (result.isEmpty()) {
            users = Collections.emptyList();
        } else {
            ArrayList list = new ArrayList(result.size());
            result.forEach(e -> list.add((DocumentReference)this.referenceFactory.getReference((EntityReference)this.resolver.resolve(e, new Object[]{wiki}))));
            users = Collections.unmodifiableList(list);
        }
        this.cache.set(cacheKey, users);
        return users;
    }

    public void cleanCache(String wiki) {
        this.cache.remove("true" + wiki);
        this.cache.remove("false" + wiki);
    }
}

