/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.group;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiGroupsDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.user.internal.group.GroupMembersCache;
import org.xwiki.user.internal.group.MemberGroupsCache;
import org.xwiki.user.internal.group.WikiGroupCache;

@Component
@Named(value="org.xwiki.user.internal.group.GroupInvalidationListener")
@Singleton
@Priority(value=99)
public class GroupCacheInvalidationListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.user.internal.group.GroupInvalidationListener";
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private MemberGroupsCache groupsCache;
    @Inject
    private GroupMembersCache membersCache;
    @Inject
    private WikiGroupCache wikiGroupCache;

    public GroupCacheInvalidationListener() {
        super(NAME, new Event[]{new WikiDeletedEvent(), new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            WikiReference wikiReference = new WikiReference(((WikiDeletedEvent)event).getWikiId());
            this.groupsCache.cleanCache(wikiReference.getName());
            this.membersCache.cleanCache(wikiReference.getName());
            this.wikiGroupCache.invalidate(wikiReference.getName());
        } else {
            XWikiDocument newDocument = (XWikiDocument)source;
            XWikiDocument previousDocument = newDocument.getOriginalDocument();
            DocumentReference documentReference = newDocument.getDocumentReference();
            this.groupsCache.cleanCache(documentReference);
            this.membersCache.cleanCache(documentReference);
            if (newDocument.getXObject((EntityReference)XWikiGroupsDocumentInitializer.XWIKI_GROUPS_DOCUMENT_REFERENCE) != null != (previousDocument.getXObject((EntityReference)XWikiGroupsDocumentInitializer.XWIKI_GROUPS_DOCUMENT_REFERENCE) != null)) {
                this.wikiGroupCache.invalidate(documentReference.getWikiReference().getName());
            }
            Set<DocumentReference> previousMembers = this.getMembers(previousDocument);
            Set<DocumentReference> newMembers = this.getMembers(newDocument);
            this.invalidate(previousMembers, newMembers);
            this.invalidate(newMembers, previousMembers);
        }
    }

    private void invalidate(Set<DocumentReference> members1, Set<DocumentReference> members2) {
        for (DocumentReference member : members1) {
            if (members2.contains(member)) continue;
            this.groupsCache.cleanCache(member);
            this.membersCache.cleanCache(member);
        }
    }

    private Set<DocumentReference> getMembers(XWikiDocument document) {
        List memberObjects = document.getXObjects((EntityReference)XWikiGroupsDocumentInitializer.XWIKI_GROUPS_DOCUMENT_REFERENCE);
        if (memberObjects.isEmpty()) {
            return Set.of();
        }
        HashSet<DocumentReference> members = new HashSet<DocumentReference>(memberObjects.size());
        for (BaseObject memberObject : memberObjects) {
            String memberString;
            if (memberObject == null || !StringUtils.isNotEmpty((CharSequence)(memberString = memberObject.getStringValue("member")))) continue;
            members.add(this.resolver.resolve((Object)memberString, new Object[]{document.getDocumentReference()}));
        }
        return members;
    }
}

