/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.group;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.event.AbstractCacheEntryListener;
import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

public abstract class AbstractGroupCache
extends AbstractCacheEntryListener<GroupCacheEntry>
implements Initializable,
Disposable {
    private static final int DEFAULT_CAPACITY = 1000;
    @Inject
    protected EntityReferenceSerializer<String> serializer;
    protected Cache<GroupCacheEntry> cache;
    @Inject
    private CacheManager cacheManager;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final String id;
    private Map<DocumentReference, Set<String>> cacheDocumentIndex = new ConcurrentHashMap<DocumentReference, Set<String>>();

    public AbstractGroupCache(String id) {
        this.id = id;
    }

    public void initialize() throws InitializationException {
        CacheConfiguration cacheConfig = new CacheConfiguration();
        cacheConfig.setConfigurationId(this.id);
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setMaxEntries(1000);
        cacheConfig.put((Object)"eviction", (Object)lru);
        try {
            this.cache = this.cacheManager.createNewCache(cacheConfig);
            this.cache.addCacheEntryListener((CacheEntryListener)this);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to create the group cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroupCacheEntry getCacheEntry(String key, DocumentReference reference, boolean create) {
        GroupCacheEntry entry;
        this.lockRead();
        try {
            entry = (GroupCacheEntry)this.cache.get(key);
        }
        finally {
            this.unlockRead();
        }
        if (entry == null && create) {
            this.lockWrite();
            try {
                entry = (GroupCacheEntry)this.cache.get(key);
                if (entry == null) {
                    entry = new GroupCacheEntry(key);
                    this.cache.set(key, (Object)entry);
                    this.addToIndex(key, reference);
                }
            }
            finally {
                this.unlockWrite();
            }
        }
        return entry;
    }

    private void addToIndex(String key, DocumentReference reference) {
        this.cacheDocumentIndex.computeIfAbsent(reference, k -> new HashSet()).add(key);
    }

    private void addToIndex(String key, Collection<DocumentReference> references) {
        for (DocumentReference reference : references) {
            this.addToIndex(key, reference);
        }
    }

    private void cleanIndex(String key, Collection<DocumentReference> references) {
        if (references != null) {
            for (DocumentReference reference : references) {
                Set<String> keys = this.cacheDocumentIndex.get(reference);
                if (keys == null) continue;
                keys.remove(key);
                if (!keys.isEmpty()) continue;
                this.cacheDocumentIndex.remove(reference);
            }
        }
    }

    public void lockWrite() {
        this.lock.writeLock().lock();
    }

    public void unlockWrite() {
        this.lock.writeLock().unlock();
    }

    public void lockRead() {
        this.lock.readLock().lock();
    }

    public void unlockRead() {
        this.lock.readLock().unlock();
    }

    public void cleanCache(DocumentReference reference) {
        this.lockWrite();
        try {
            this.cleanDocumentCache(reference);
        }
        finally {
            this.unlockWrite();
        }
    }

    private void cleanDocumentCache(DocumentReference reference) {
        Set<String> keys = this.cacheDocumentIndex.remove(reference);
        if (keys != null) {
            for (String key : keys) {
                this.cache.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanCache(String wiki) {
        this.lockWrite();
        try {
            for (Map.Entry<DocumentReference, Set<String>> entry : this.cacheDocumentIndex.entrySet()) {
                DocumentReference reference = entry.getKey();
                if (!reference.getWikiReference().getName().equals(wiki)) continue;
                this.cleanDocumentCache(reference);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    public void removeAll() {
        this.lockWrite();
        try {
            this.cache.removeAll();
            this.cacheDocumentIndex.clear();
        }
        finally {
            this.unlockWrite();
        }
    }

    public void cacheEntryRemoved(CacheEntryEvent<GroupCacheEntry> event) {
        String key = event.getEntry().getKey();
        GroupCacheEntry entry = (GroupCacheEntry)event.getEntry().getValue();
        this.cleanIndex(key, entry.getDirect());
        this.cleanIndex(key, entry.getAll());
    }

    public void dispose() throws ComponentLifecycleException {
        this.removeAll();
    }

    public class GroupCacheEntry {
        private final String key;
        private Collection<DocumentReference> direct;
        private Collection<DocumentReference> all;

        GroupCacheEntry(String key) {
            this.key = key;
        }

        public Collection<DocumentReference> getDirect() {
            return this.direct;
        }

        public Collection<DocumentReference> setDirect(Collection<DocumentReference> direct) {
            this.direct = Collections.unmodifiableCollection(direct);
            AbstractGroupCache.this.addToIndex(this.key, direct);
            return this.direct;
        }

        public Collection<DocumentReference> getAll() {
            return this.all;
        }

        public Collection<DocumentReference> setAll(Collection<DocumentReference> all) {
            this.all = Collections.unmodifiableCollection(all);
            AbstractGroupCache.this.addToIndex(this.key, all);
            return this.all;
        }
    }
}

