/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import java.util.ArrayList;
import java.util.Map;
import org.xwiki.configuration.ConfigurationRight;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.ConfigurationSourceAuthorization;
import org.xwiki.configuration.internal.ConfigurationSourceDecorator;
import org.xwiki.text.StringUtils;
import org.xwiki.user.UserReference;
import org.xwiki.user.internal.document.DocumentUserReference;

public class SecureDocumentConfigurationSource
extends ConfigurationSourceDecorator {
    private ConfigurationSourceAuthorization authorization;
    private DocumentUserReference userReference;

    public SecureDocumentConfigurationSource(DocumentUserReference userReference, ConfigurationSource internalConfigurationSource, ConfigurationSourceAuthorization authorization) {
        super(internalConfigurationSource);
        this.userReference = userReference;
        this.authorization = authorization;
    }

    public <T> T getProperty(String key, T defaultValue) {
        Object value = this.hasAccess(key, ConfigurationRight.READ) ? this.getWrappedConfigurationSource().getProperty(key, defaultValue) : defaultValue;
        return value;
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        Object value = this.hasAccess(key, ConfigurationRight.READ) ? this.getWrappedConfigurationSource().getProperty(key, valueClass) : null;
        return (T)value;
    }

    public <T> T getProperty(String key) {
        Object value = this.hasAccess(key, ConfigurationRight.READ) ? this.getWrappedConfigurationSource().getProperty(key) : null;
        return (T)value;
    }

    public <T> T getProperty(String key, Class<T> valueClass, T defaultValue) {
        Object value = this.hasAccess(key, ConfigurationRight.READ) ? this.getWrappedConfigurationSource().getProperty(key, valueClass, defaultValue) : defaultValue;
        return value;
    }

    public void setProperties(Map<String, Object> properties) throws ConfigurationSaveException {
        ArrayList<String> notAccessibleKeys = new ArrayList<String>();
        boolean hasAccess = true;
        for (String key : properties.keySet()) {
            boolean access = this.hasAccess(key, ConfigurationRight.WRITE);
            if (!access) {
                notAccessibleKeys.add(String.format("[%s]", key));
            }
            hasAccess = hasAccess && access;
        }
        if (!hasAccess) {
            throw new ConfigurationSaveException(String.format("No permission for user [%s] to modify keys [%s]", this.userReference, StringUtils.join(notAccessibleKeys, (char)',')));
        }
        this.getWrappedConfigurationSource().setProperties(properties);
    }

    private boolean hasAccess(String key, ConfigurationRight configurationRight) {
        return this.authorization.hasAccess(key, (UserReference)this.userReference, configurationRight);
    }
}

