/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.user.UserException;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserReference;
import org.xwiki.user.internal.document.DocumentUserReference;
import org.xwiki.user.internal.document.UserCache;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="org.xwiki.user.internal.document.DocumentUserReference")
@Singleton
public class DocumentUserManager
implements UserManager {
    public static final String HINT = "org.xwiki.user.internal.document.DocumentUserReference";
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    private UserCache userCache;

    public boolean exists(UserReference userReference) throws UserException {
        boolean result;
        XWikiContext xcontext = (XWikiContext)this.xwikiContextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        DocumentReference userDocumentReference = ((DocumentUserReference)userReference).getReference();
        String userWikiId = userDocumentReference.getWikiReference().getName();
        try {
            result = !this.wikiDescriptorManager.exists(userWikiId) ? false : this.exists(xcontext, xwiki, userDocumentReference);
        }
        catch (WikiManagerException e) {
            throw new UserException(String.format("Failed to determine if wiki [%s] exists.", userWikiId), (Throwable)e);
        }
        return result;
    }

    private boolean exists(XWikiContext xcontext, XWiki xwiki, DocumentReference userDocumentReference) throws UserException {
        boolean result;
        try {
            XWikiDocument document = xwiki.getDocument(userDocumentReference, xcontext);
            result = !document.isNew() && document.getXObject((EntityReference)XWikiUsersDocumentInitializer.XWIKI_USERS_DOCUMENT_REFERENCE) != null;
        }
        catch (Exception e) {
            throw new UserException(String.format("Failed to check if document [%s] holds an XWiki user or not. ", userDocumentReference), (Throwable)e);
        }
        return result;
    }

    public boolean hasUsers(WikiReference wiki) throws UserException {
        return this.userCache.computeIfAbsent(wiki, this::hasUserInternal);
    }

    private Boolean hasUserInternal(WikiReference wiki) throws UserException {
        try {
            Query query = this.queryManager.createQuery("select doc.id from Document doc, doc.object(XWiki.XWikiUsers) as user", "xwql");
            query.setLimit(1);
            query.setWiki(wiki.getName());
            return !query.execute().isEmpty();
        }
        catch (QueryException e) {
            throw new UserException("Failed to query users", (Throwable)e);
        }
    }
}

