/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Named(value="document")
@Singleton
public class DocumentDocumentReferenceUserReferenceSerializer
implements UserReferenceSerializer<DocumentReference> {
    private static final String XWIKI_SPACE = "XWiki";
    @Inject
    private EntityReferenceProvider entityReferenceProvider;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserReferenceUserReferenceResolver;

    public DocumentReference serialize(UserReference userReference) {
        DocumentReference result;
        UserReference normalizedUserReference = userReference;
        if (userReference == null || CurrentUserReference.INSTANCE == normalizedUserReference) {
            normalizedUserReference = this.currentUserReferenceUserReferenceResolver.resolve(null, new Object[0]);
        }
        if (SuperAdminUserReference.INSTANCE == normalizedUserReference) {
            result = new DocumentReference(this.entityReferenceProvider.getDefaultReference(EntityType.WIKI).getName(), XWIKI_SPACE, "superadmin");
        } else if (GuestUserReference.INSTANCE == normalizedUserReference) {
            result = null;
        } else {
            if (!(normalizedUserReference instanceof DocumentUserReference)) {
                throw new IllegalArgumentException(String.format("Passed user reference must be of type [%s]", DocumentUserReference.class.getName()));
            }
            result = ((DocumentUserReference)normalizedUserReference).getReference();
        }
        return result;
    }
}

