/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal.document;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.internal.document.AbstractUserReferenceResolver;
import org.xwiki.user.internal.document.DocumentUserReference;

public abstract class AbstractDocumentStringUserReferenceResolver
extends AbstractUserReferenceResolver<String> {
    private static final EntityReference USER_SPACE_REFERENCE = new EntityReference("XWiki", EntityType.SPACE);
    @Inject
    private EntityReferenceProvider entityReferenceProvider;

    public UserReference resolve(String userName, Object ... parameters) {
        Object reference;
        if (StringUtils.isEmpty((CharSequence)userName)) {
            reference = CurrentUserReference.INSTANCE;
        } else {
            EntityReference baseEntityReference = parameters.length == 1 && parameters[0] instanceof WikiReference ? new EntityReference(USER_SPACE_REFERENCE, (EntityReference)((WikiReference)parameters[0])) : USER_SPACE_REFERENCE;
            DocumentReference documentReference = this.getDocumentReferenceResolver().resolve((Object)userName, new Object[]{baseEntityReference});
            UserReference resolvedReference = this.resolveName(documentReference.getName());
            if (resolvedReference == null) {
                boolean isGlobal = this.entityReferenceProvider.getDefaultReference(EntityType.WIKI).equals((Object)documentReference.getWikiReference());
                reference = new DocumentUserReference(documentReference, isGlobal);
            } else {
                reference = resolvedReference;
            }
        }
        return reference;
    }

    protected abstract DocumentReferenceResolver<String> getDocumentReferenceResolver();
}

