/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.user.internal;

import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.user.UserConfiguration;

@Component
@Singleton
public class DefaultUserConfiguration
implements UserConfiguration {
    private static final String PREFIX = "user.";
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiPropertiesSource;

    public String getStoreHint() {
        return (String)this.xwikiPropertiesSource.getProperty("user.hint", (Object)"document");
    }

    public Properties getSuperAdminPreferences() {
        return this.getPreferencesFor("superadmin");
    }

    public Properties getGuestPreference() {
        return this.getPreferencesFor("guest");
    }

    public String getUserQualifierProperty() {
        return (String)this.xwikiPropertiesSource.getProperty("user.display.qualifierProperty");
    }

    private Properties getPreferencesFor(String userName) {
        Properties properties = new Properties();
        for (String key : this.xwikiPropertiesSource.getKeys()) {
            String preferenceKey = StringUtils.substringAfter((String)key, (String)("user.preferences." + userName + "."));
            if (StringUtils.isEmpty((CharSequence)preferenceKey)) continue;
            properties.setProperty(preferenceKey, (String)this.xwikiPropertiesSource.getProperty(key));
        }
        return properties;
    }
}

