/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.resource.internal.entity.EntityResourceActionLister;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;

public abstract class AbstractEntityResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    private static final String VIEW_ACTION = "view";
    private static final String DOWNLOAD_ACTION = "download";
    private static final String DELATTACHMENT_ACTION = "delattachment";
    private static final String VIEWATTACHREV_ACTION = "viewattachrev";
    private static final String DOWNLOADREV_ACTION = "downloadrev";
    private static final String SKIN_ACTION = "skin";
    private static final List<String> FILE_ACTION_LIST = Arrays.asList("download", "delattachment", "viewattachrev", "downloadrev", "skin");
    private EntityResourceActionLister entityResourceActionLister;
    private EntityReferenceResolver<EntityReference> defaultReferenceEntityReferenceResolver;

    protected abstract WikiReference extractWikiReference(ExtendedURL var1);

    public EntityResourceReference resolve(ExtendedURL extendedURL, ResourceType type, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        WikiReference wikiReference = this.extractWikiReference(extendedURL);
        List pathSegments = extendedURL.getSegments();
        List<String> spaceNames = null;
        String pageName = null;
        String attachmentName = null;
        String action = VIEW_ACTION;
        if (!pathSegments.isEmpty()) {
            String firstSegment;
            action = firstSegment = (String)pathSegments.get(0);
            if (FILE_ACTION_LIST.contains(firstSegment) && pathSegments.size() >= 4) {
                attachmentName = (String)pathSegments.get(pathSegments.size() - 1);
                pageName = (String)pathSegments.get(pathSegments.size() - 2);
                spaceNames = this.extractSpaceNames(pathSegments, 1, pathSegments.size() - 3);
            } else {
                Pair<String, Integer> actionAndStartPosition = this.computeActionAndStartPosition(firstSegment);
                action = (String)actionAndStartPosition.getLeft();
                int startPosition = (Integer)actionAndStartPosition.getRight();
                if (pathSegments.size() - startPosition == 1) {
                    spaceNames = Arrays.asList((String)pathSegments.get(startPosition));
                } else {
                    pageName = (String)pathSegments.get(pathSegments.size() - 1);
                    spaceNames = this.extractSpaceNames(pathSegments, startPosition, pathSegments.size() - 2);
                }
            }
        }
        EntityResourceReference reference = new EntityResourceReference(this.buildEntityReference(wikiReference, spaceNames, pageName, attachmentName), EntityResourceAction.fromString((String)action), extendedURL.getURI().getFragment());
        this.copyParameters(extendedURL, (ResourceReference)reference);
        return reference;
    }

    private Pair<String, Integer> computeActionAndStartPosition(String firstSegment) {
        int startPosition;
        String action;
        if (!this.entityResourceActionLister.listActions().contains(firstSegment)) {
            action = VIEW_ACTION;
            startPosition = 0;
        } else {
            action = firstSegment;
            startPosition = 1;
        }
        return new ImmutablePair((Object)action, (Object)startPosition);
    }

    private List<String> extractSpaceNames(List<String> pathSegments, int startPosition, int stopPosition) {
        if (stopPosition < 0) {
            return null;
        }
        ArrayList<String> spaceNames = new ArrayList<String>();
        ListIterator<String> iterator = pathSegments.listIterator(startPosition);
        int total = stopPosition - startPosition + 1;
        for (int count = 0; count < total; ++count) {
            spaceNames.add(iterator.next());
        }
        return spaceNames;
    }

    private EntityReference buildEntityReference(WikiReference wikiReference, List<String> spaceNames, String pageName, String attachmentName) {
        WikiReference reference = wikiReference;
        EntityType entityType = EntityType.DOCUMENT;
        if (spaceNames != null && !spaceNames.isEmpty()) {
            WikiReference parent = reference;
            for (String spaceName : spaceNames) {
                if (StringUtils.isEmpty((CharSequence)spaceName)) continue;
                parent = reference = new EntityReference(spaceName, EntityType.SPACE, (EntityReference)parent);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)pageName)) {
            reference = new EntityReference(pageName, EntityType.DOCUMENT, (EntityReference)reference);
        }
        if (!StringUtils.isEmpty((CharSequence)attachmentName)) {
            reference = new EntityReference(attachmentName, EntityType.ATTACHMENT, (EntityReference)reference);
            entityType = EntityType.ATTACHMENT;
        }
        return this.defaultReferenceEntityReferenceResolver.resolve((Object)reference, entityType, new Object[0]);
    }
}

