/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import com.xpn.xwiki.XWikiContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.DefaultStringEntityReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.CreateResourceTypeException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.ResourceTypeResolver;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.url.ExtendedURL;

@Component
@Named(value="resource/standardURL")
@Singleton
public class StandardURLStringEntityReferenceResolver
extends DefaultStringEntityReferenceResolver {
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="standard")
    private ResourceReferenceResolver<ExtendedURL> resourceResolver;
    @Inject
    @Named(value="standard")
    private ResourceTypeResolver<ExtendedURL> typeResolver;
    @Inject
    private EntityReferenceResolver<String> defaultStringResolver;

    public EntityReference resolve(String urlStringRepresentation, EntityType type, Object ... parameters) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            ExtendedURL extendedURL = new ExtendedURL(new URL(urlStringRepresentation), xcontext.getRequest().getContextPath());
            ResourceType resourceType = this.typeResolver.resolve((Object)extendedURL, Collections.emptyMap());
            ResourceReference reference = this.resourceResolver.resolve((Object)extendedURL, resourceType, Collections.emptyMap());
            if (reference instanceof EntityResourceReference) {
                EntityReference entityReference = ((EntityResourceReference)reference).getEntityReference();
                return entityReference;
            }
        }
        catch (MalformedURLException | CreateResourceReferenceException | CreateResourceTypeException | UnsupportedResourceReferenceException e) {
            this.logger.warn("Failed to extract an EntityReference from [{}]. Root cause is [{}].", (Object)urlStringRepresentation, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return this.defaultStringResolver.resolve((Object)urlStringRepresentation, type, parameters);
    }
}

