/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.script;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;
import org.xwiki.url.FrontendURLCheckPolicy;
import org.xwiki.url.URLConfiguration;
import org.xwiki.url.URLSecurityManager;

@Component
@Named(value="security.url")
@Singleton
public class URLSecurityScriptService
implements ScriptService {
    @Inject
    private URLSecurityManager urlSecurityManager;
    @Inject
    private URLConfiguration urlConfiguration;
    @Inject
    private Logger logger;

    public URI parseToSafeURI(String uriRepresentation) throws URISyntaxException, SecurityException {
        try {
            return this.urlSecurityManager.parseToSafeURI(uriRepresentation);
        }
        catch (SecurityException e) {
            this.logger.info("The URI [{}] is considered not safe: [{}]", (Object)uriRepresentation, (Object)e.getMessage());
            this.logger.debug("Security exception stack trace: ", (Throwable)e);
            return null;
        }
    }

    @Unstable
    public List<String> getTrustedDomains() {
        return this.urlConfiguration.getTrustedDomains();
    }

    @Unstable
    public FrontendURLCheckPolicy getFrontendUrlCheckPolicy() {
        return this.urlConfiguration.getFrontendUrlCheckPolicy();
    }

    @Unstable
    public List<String> getAllowedFrontendUrls() {
        return this.urlConfiguration.getAllowedFrontendUrls();
    }
}

