/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.objects.BaseObject;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.context.Execution;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityContext;
import org.xwiki.velocity.XWikiVelocityException;

public class WikiUIExtensionParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiUIExtensionParameters.class);
    private String id;
    private Properties parameters;
    private Map<String, String> evaluatedParameters;
    private int previousContextId;
    private String previousWiki;
    private VelocityManager velocityManager;
    private ModelContext modelContext;
    private LoggerConfiguration loggerConfiguration;
    private Execution execution;
    private AuthorExecutor authorExecutor;
    private final DocumentReference documentReference;
    private final DocumentReference authorReference;
    private final DocumentAuthorizationManager authorizationManager;

    public WikiUIExtensionParameters(BaseObject baseObject, ComponentManager cm) throws WikiComponentException {
        this.id = baseObject.getStringValue("name");
        this.parameters = this.parseParameters(baseObject.getStringValue("parameters"));
        this.documentReference = baseObject.getDocumentReference();
        this.authorReference = baseObject.getOwnerDocument().getAuthorReference();
        try {
            this.execution = (Execution)cm.getInstance(Execution.class);
            this.velocityManager = (VelocityManager)cm.getInstance(VelocityManager.class);
            this.modelContext = (ModelContext)cm.getInstance(ModelContext.class);
            this.loggerConfiguration = (LoggerConfiguration)cm.getInstance(LoggerConfiguration.class);
            this.authorExecutor = (AuthorExecutor)cm.getInstance(AuthorExecutor.class);
            this.authorizationManager = (DocumentAuthorizationManager)cm.getInstance(DocumentAuthorizationManager.class);
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException("Failed to get an instance for a component role required by Wiki Components.", (Throwable)e);
        }
    }

    private Properties parseParameters(String rawParameters) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(rawParameters));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to parse UIX parameters [{}]. Cause [{}].", (Object)rawParameters, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return properties;
    }

    public Map<String, String> get() {
        Map<String, String> result;
        int currentContextId = this.execution.getContext().hashCode();
        String currentWiki = this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName();
        if (currentContextId == this.previousContextId && currentWiki.equals(this.previousWiki) && this.evaluatedParameters != null) {
            result = this.evaluatedParameters;
        } else {
            result = this.parameters.stringPropertyNames().stream().filter(StringUtils::isNotBlank).collect(Collectors.toMap(Function.identity(), this.parameters::getProperty));
            if (!this.parameters.isEmpty() && this.authorizationManager.hasAccess(Right.SCRIPT, EntityType.DOCUMENT, this.authorReference, this.documentReference)) {
                try {
                    this.authorExecutor.call(() -> {
                        VelocityEngine velocityEngine = this.velocityManager.getVelocityEngine();
                        VelocityContext velocityContext = this.velocityManager.getVelocityContext();
                        result.replaceAll((propertyKey, propertyValue) -> {
                            StringWriter writer = new StringWriter();
                            try {
                                String namespace = this.id + ":" + propertyKey;
                                velocityEngine.evaluate((Context)new XWikiVelocityContext((Context)velocityContext, this.loggerConfiguration.isDeprecatedLogEnabled()), (Writer)writer, namespace, propertyValue);
                                return writer.toString();
                            }
                            catch (XWikiVelocityException e) {
                                LOGGER.warn(String.format("Failed to evaluate UI extension data value, key [%s], value [%s]. Reason: [%s]", propertyKey, propertyValue, e.getMessage()));
                                return propertyValue;
                            }
                        });
                        return null;
                    }, this.authorReference, this.documentReference);
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("Failed to get velocity engine. Reason: [%s]", ex.getMessage()));
                }
            }
            this.evaluatedParameters = result;
            this.previousContextId = currentContextId;
            this.previousWiki = currentWiki;
        }
        return result;
    }
}

