/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.component.wiki.internal.bridge.WikiBaseObjectComponentBuilder;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.uiextension.internal.WikiUIExtension;
import org.xwiki.uiextension.internal.WikiUIExtensionConstants;
import org.xwiki.uiextension.internal.WikiUIExtensionParameters;

@Component
@Singleton
@Named(value="XWiki.UIExtensionClass")
public class WikiUIExtensionComponentBuilder
implements WikiBaseObjectComponentBuilder,
WikiUIExtensionConstants {
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="wiki")
    private ComponentManager wikiComponentManager;
    @Inject
    private Provider<WikiUIExtension> extensionProvider;
    @Inject
    private DocumentAuthorizationManager authorization;

    public EntityReference getClassReference() {
        return UI_EXTENSION_CLASS;
    }

    private void checkRights(XWikiDocument extensionsDoc, WikiComponentScope scope) throws WikiComponentException {
        if (scope == WikiComponentScope.GLOBAL) {
            if (!this.authorization.hasAccess(Right.PROGRAM, null, extensionsDoc.getAuthorReference(), extensionsDoc.getDocumentReference())) {
                throw new WikiComponentException("Registering global UI extensions requires programming rights");
            }
        } else if (scope == WikiComponentScope.WIKI && !this.authorization.hasAccess(Right.ADMIN, EntityType.WIKI, extensionsDoc.getAuthorReference(), extensionsDoc.getDocumentReference())) {
            throw new WikiComponentException("Registering UI extensions at wiki level requires wiki administration rights");
        }
    }

    public List<WikiComponent> buildComponents(BaseObject baseObject) throws WikiComponentException {
        WikiUIExtension extension;
        String extensionPointId = baseObject.getStringValue("extensionPointId");
        if (StringUtils.isEmpty((CharSequence)extensionPointId)) {
            return Collections.emptyList();
        }
        WikiComponentScope scope = WikiComponentScope.fromString((String)baseObject.getStringValue("scope"));
        XWikiDocument ownerDocument = baseObject.getOwnerDocument();
        this.checkRights(ownerDocument, scope);
        String id = baseObject.getStringValue("name");
        String roleHint = (String)this.serializer.serialize(baseObject.getReference(), new Object[0]);
        try {
            extension = (WikiUIExtension)((Object)this.extensionProvider.get());
            extension.initialize(baseObject, roleHint, id, extensionPointId);
        }
        catch (Exception e) {
            throw new WikiComponentException(String.format("Failed to initialize Panel UI extension [%s]", baseObject.getReference()), (Throwable)e);
        }
        WikiUIExtensionParameters parameters = new WikiUIExtensionParameters(baseObject, this.wikiComponentManager);
        extension.setParameters(parameters);
        extension.setScope(scope);
        return Collections.singletonList(extension);
    }
}

