/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.component.wiki.internal.bridge.ContentParser;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.velocity.internal.util.VelocityDetector;

@Component
@Named(value="XWiki.UIExtensionClass")
@Singleton
public class UIExtensionRequiredRightsAnalyzer
implements RequiredRightAnalyzer<BaseObject> {
    private static final Set<String> ADMIN_ONLY_EXTENSION_POINTS = Set.of("org.xwiki.plaftorm.drawer.header", "org.xwiki.plaftorm.drawer", "org.xwiki.platform.notifications", "org.xwiki.plaftorm.menu.content", "org.xwiki.plaftorm.editactions", "org.xwiki.plaftorm.adminactions", "org.xwiki.plaftorm.moreoptions", "org.xwiki.platform.template.menu.viewers", "org.xwiki.platform.topmenu.left", "org.xwiki.platform.topmenu.right");
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationBlockSupplierProvider;
    @Inject
    @Named(value="stringCode")
    private BlockSupplierProvider<String> stringBlockSupplierProvider;
    @Inject
    private BlockSupplierProvider<BaseObject> objectBlockSupplierProvider;
    @Inject
    private ContentParser parser;
    @Inject
    private RequiredRightAnalyzer<XDOM> xdomRequiredRightAnalyzer;
    @Inject
    private VelocityDetector velocityDetector;

    public List<RequiredRightAnalysisResult> analyze(BaseObject object) throws RequiredRightsException {
        WikiComponentScope scope = WikiComponentScope.fromString((String)object.getStringValue("scope"));
        ArrayList<RequiredRightAnalysisResult> result = new ArrayList<RequiredRightAnalysisResult>();
        BaseObjectReference reference = (BaseObjectReference)object.getReference();
        if (scope == WikiComponentScope.GLOBAL) {
            result.add(new RequiredRightAnalysisResult((EntityReference)reference, this.translationBlockSupplierProvider.get((Object)"uiextension.requiredrights.global", new Object[0]), this.objectBlockSupplierProvider.get((Object)object, new Object[0]), List.of(RequiredRight.PROGRAM)));
        } else if (scope == WikiComponentScope.WIKI) {
            result.add(new RequiredRightAnalysisResult((EntityReference)reference, this.translationBlockSupplierProvider.get((Object)"uiextension.requiredrights.wiki", new Object[0]), this.objectBlockSupplierProvider.get((Object)object, new Object[0]), List.of(RequiredRight.WIKI_ADMIN)));
        } else {
            String extensionPoint = object.getStringValue("extensionPointId");
            if (StringUtils.isNotBlank((CharSequence)extensionPoint) && ADMIN_ONLY_EXTENSION_POINTS.contains(extensionPoint)) {
                result.add(new RequiredRightAnalysisResult((EntityReference)reference, this.translationBlockSupplierProvider.get((Object)"uiextension.requiredrights.adminOnly", new Object[]{extensionPoint}), this.objectBlockSupplierProvider.get((Object)object, new Object[0]), List.of(RequiredRight.WIKI_ADMIN)));
            }
        }
        String parameters = object.getStringValue("parameters");
        if (this.velocityDetector.containsVelocityScript(parameters)) {
            result.add(new RequiredRightAnalysisResult((EntityReference)reference, this.translationBlockSupplierProvider.get((Object)"uiextension.requiredrights.parameters", new Object[0]), this.stringBlockSupplierProvider.get((Object)parameters, new Object[0]), RequiredRight.SCRIPT_AND_MAYBE_PROGRAM));
        }
        String content = object.getStringValue("content");
        try {
            if (StringUtils.isNotBlank((CharSequence)content)) {
                XWikiDocument ownerDocument = object.getOwnerDocument();
                XDOM xdom = this.parser.parse(content, ownerDocument.getSyntax(), (EntityReference)object.getDocumentReference());
                xdom.getMetaData().addMetaData("entityReference", (Object)reference);
                result.addAll(this.xdomRequiredRightAnalyzer.analyze((Object)xdom));
            }
        }
        catch (Exception e) {
            result.add(new RequiredRightAnalysisResult((EntityReference)reference, this.translationBlockSupplierProvider.get((Object)"uiextension.requiredrights.contentError", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)}), this.stringBlockSupplierProvider.get((Object)content, new Object[0]), List.of(RequiredRight.MAYBE_PROGRAM)));
        }
        return result;
    }
}

