/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import java.util.Arrays;
import javax.inject.Inject;
import org.xwiki.component.wiki.internal.AbstractAsyncContentBaseObjectWikiComponent;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererDecorator;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.util.ErrorBlockGenerator;
import org.xwiki.uiextension.UIExtension;

public abstract class AbstractWikiUIExtension
extends AbstractAsyncContentBaseObjectWikiComponent
implements UIExtension {
    private static final String TM_FAILEDUIX = "uiextension.error.failed";
    @Inject
    protected JobProgressManager progress;
    @Inject
    protected ErrorBlockGenerator errorBlockGenerator;
    @Inject
    protected AsyncContext asyncContext;
    @Inject
    protected RenderingContext renderingContext;

    protected String getContentPropertyName() {
        return "content";
    }

    public DocumentReference getDocumentReference() {
        return this.objectReference.getDocumentReference();
    }

    public EntityReference getEntityReference() {
        return this.objectReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public Block execute() {
        return this.execute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block execute(boolean inline) {
        Block result;
        this.progress.startStep((Object)this, "uix.progress.execute", "Execute UIX with id [{}]", new Object[]{this.getId()});
        try {
            BlockAsyncRendererConfiguration executorConfiguration = this.configure(inline);
            result = this.executor.execute(executorConfiguration);
        }
        catch (Exception e) {
            result = new CompositeBlock(this.errorBlockGenerator.generateErrorBlocks(false, TM_FAILEDUIX, "Failed to execute UIX with id [{}]", null, new Object[]{this.getId(), e}));
        }
        finally {
            this.progress.endStep((Object)this);
        }
        return result;
    }

    protected BlockAsyncRendererConfiguration configure(boolean inline) {
        XDOM transformedBlock = this.getPreparedContent();
        transformedBlock = transformedBlock.clone();
        BlockAsyncRendererConfiguration executorConfiguration = new BlockAsyncRendererConfiguration(Arrays.asList("uix", this.getId()), (Block)transformedBlock);
        executorConfiguration.setTransformationId(this.getRoleHint());
        executorConfiguration.setDefaultSyntax(this.syntax);
        executorConfiguration.setInline(inline);
        executorConfiguration.setSecureReference(this.getDocumentReference(), this.getAuthorReference());
        executorConfiguration.setTargetSyntax(this.renderingContext.getTargetSyntax());
        if (this instanceof BlockAsyncRendererDecorator) {
            executorConfiguration.setDecorator((BlockAsyncRendererDecorator)this);
        }
        executorConfiguration.setAsyncAllowed(this.asyncAllowed);
        executorConfiguration.setCacheAllowed(this.cacheAllowed);
        if (this.cacheAllowed) {
            executorConfiguration.useComponent(this.getRoleType(), this.getRoleHint());
        }
        executorConfiguration.setContextEntries(this.contextEntries);
        return executorConfiguration;
    }
}

