/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal.macro;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.UIExtensionManager;
import org.xwiki.uiextension.macro.UIExtensionMacroParameters;

@Component
@Named(value="uiextension")
@Singleton
public class UIExtensionMacro
extends AbstractMacro<UIExtensionMacroParameters> {
    private static final String DESCRIPTION = "Insert a UI extension.";
    @Inject
    private UIExtensionManager uiextensions;

    public UIExtensionMacro() {
        super("UI Extensions", DESCRIPTION, UIExtensionMacroParameters.class);
        this.setDefaultCategories(Set.of("Development"));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(UIExtensionMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        Optional<UIExtension> extension = this.uiextensions.getUIExtension(parameters.getId());
        if (extension.isEmpty()) {
            throw new MacroExecutionException("Failed to find an extension id id [" + parameters.getId() + "]");
        }
        Block block = extension.get().execute(context.isInline());
        if (block instanceof XDOM || block instanceof CompositeBlock) {
            return block.getChildren();
        }
        return Collections.singletonList(block);
    }
}

