/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tree.internal;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
@Named(value="entityTreeNodeId")
public class EntityTreeNodeIdConverter
extends AbstractConverter<EntityReference> {
    @Inject
    protected EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<String> currentEntityReferenceResolver;

    protected String convertToString(EntityReference entityReference) {
        if (entityReference == null) {
            return null;
        }
        return this.underscoreToCamelCase(entityReference.getType().name().toLowerCase()) + ":" + (String)this.defaultEntityReferenceSerializer.serialize(entityReference, new Object[0]);
    }

    private String underscoreToCamelCase(String entityType) {
        StringBuilder result = new StringBuilder();
        for (String part : StringUtils.split((String)entityType, (char)'_')) {
            result.append(StringUtils.capitalize((String)part));
        }
        return StringUtils.uncapitalize((String)result.toString());
    }

    protected EntityReference convertToType(Type targetType, Object value) {
        String[] parts = StringUtils.split((String)String.valueOf(value), (String)":", (int)2);
        if (parts == null || parts.length != 2) {
            return null;
        }
        try {
            EntityType entityType = EntityType.valueOf((String)this.camelCaseToUnderscore(parts[0]).toUpperCase());
            return this.currentEntityReferenceResolver.resolve((Object)parts[1], entityType, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String camelCaseToUnderscore(String nodeType) {
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)nodeType), (char)'_');
    }
}

